/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.util;

import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.obeonetwork.m2doc.parser.TokenProvider;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFldChar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;

public class FieldUtils {
    public String lookAheadTag(TokenProvider runIterator) {
        int i = 1;
        XWPFRun run = runIterator.lookAhead(i).getRun();
        if (run == null) {
            throw new IllegalStateException("lookAheadTag shouldn't be called on a table.");
        }
        if (this.isFieldBegin(run)) {
            StringBuilder builder = new StringBuilder();
            run = runIterator.lookAhead(++i).getRun();
            while (run != null && !this.isFieldEnd(run)) {
                builder.append((CharSequence)FieldUtils.readUpInstrText(run));
                run = runIterator.lookAhead(++i).getRun();
            }
            return builder.toString().trim();
        }
        return "";
    }

    public boolean isFieldBegin(XWPFRun run) {
        if (run.getCTR().getFldCharList().size() > 0) {
            CTFldChar fldChar = (CTFldChar)run.getCTR().getFldCharList().get(0);
            return STFldCharType.BEGIN.equals(fldChar.getFldCharType());
        }
        return false;
    }

    public boolean isFieldEnd(XWPFRun run) {
        if (run.getCTR().getFldCharList().size() > 0) {
            CTFldChar fldChar = (CTFldChar)run.getCTR().getFldCharList().get(0);
            return STFldCharType.END.equals(fldChar.getFldCharType());
        }
        return false;
    }

    public static StringBuilder readUpInstrText(XWPFRun run) {
        List texts = run.getCTR().getInstrTextList();
        StringBuilder runBuilder = new StringBuilder();
        for (CTText text : texts) {
            runBuilder.append(text.getStringValue());
        }
        return runBuilder;
    }
}

