/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class AbstractAddStepFilterAction
extends ObjectActionDelegate {
    public void run(IAction action) {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null) {
            return;
        }
        for (IJavaStackFrame frame : selection) {
            String pattern = this.generateStepFilterPattern(frame);
            if (pattern == null) continue;
            this.addActiveStepFilter(pattern);
        }
    }

    private void addActiveStepFilter(String pattern) {
        IPreferenceStore prefStore = this.getPreferenceStore();
        String[] activeArray = JavaDebugOptionsManager.parseList(prefStore.getString(IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST));
        String[] inactiveArray = JavaDebugOptionsManager.parseList(prefStore.getString(IJDIPreferencesConstants.PREF_INACTIVE_FILTERS_LIST));
        ArrayList<String> activeList = new ArrayList<String>(Arrays.asList(activeArray));
        ArrayList<String> inactiveList = new ArrayList<String>(Arrays.asList(inactiveArray));
        if (activeList.contains(pattern)) {
            return;
        }
        activeList.add(pattern);
        String activePref = JavaDebugOptionsManager.serializeList(activeList.toArray(new String[activeList.size()]));
        prefStore.setValue(IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST, activePref);
        if (inactiveList.contains(pattern)) {
            inactiveList.remove(pattern);
            String inactivePref = JavaDebugOptionsManager.serializeList(inactiveList.toArray(new String[inactiveList.size()]));
            prefStore.setValue(IJDIPreferencesConstants.PREF_INACTIVE_FILTERS_LIST, inactivePref);
        }
    }

    private IPreferenceStore getPreferenceStore() {
        return JDIDebugUIPlugin.getDefault().getPreferenceStore();
    }

    protected abstract String generateStepFilterPattern(IJavaStackFrame var1);
}

