/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;

public final class TokenRegistry {
    public static final TokenRegistry INSTANCE = new TokenRegistry();
    public static final String DEFAULT_TOKEN = "default";
    private Map<String, Map<String, List<String>>> servicesRegistry = new LinkedHashMap<String, Map<String, List<String>>>();
    private Map<String, List<String>> packagesRegistry = new LinkedHashMap<String, List<String>>();

    public void registerServices(String tokenName, String bundleName, List<String> services) {
        List<String> list;
        Map<String, List<String>> map = this.servicesRegistry.get(tokenName);
        if (map == null) {
            map = new LinkedHashMap<String, List<String>>();
            this.servicesRegistry.put(tokenName, map);
        }
        if ((list = map.get(bundleName)) == null) {
            list = new ArrayList<String>();
            map.put(bundleName, list);
        }
        list.addAll(services);
    }

    public void registerPackages(String tokenName, List<String> packages) {
        List<String> list = this.packagesRegistry.get(tokenName);
        if (list == null) {
            list = new ArrayList<String>();
            this.packagesRegistry.put(tokenName, list);
        }
        list.addAll(packages);
    }

    public void unregisterServices(String tokenName, String bundleName, List<String> services) {
        List<String> list;
        Map<String, List<String>> map = this.servicesRegistry.get(tokenName);
        if (map != null && (list = map.get(bundleName)).removeAll(services) && list.isEmpty()) {
            map.remove(bundleName);
            if (map.isEmpty()) {
                this.servicesRegistry.remove(tokenName);
            }
        }
    }

    public void unregisterPackages(String tokenName, List<String> packages) {
        List<String> list = this.packagesRegistry.get(tokenName);
        if (list != null && list.removeAll(packages) && list.isEmpty()) {
            this.packagesRegistry.remove(tokenName);
        }
    }

    public Map<String, List<String>> getServices(String tokenName) {
        Map<String, List<String>> result = this.servicesRegistry.get(tokenName);
        result = result == null ? Collections.emptyMap() : Collections.unmodifiableMap(result);
        return result;
    }

    public List<String> getPackages(String tokenName) {
        List<String> result = this.packagesRegistry.get(tokenName);
        result = result == null ? Collections.emptyList() : Collections.unmodifiableList(result);
        return result;
    }

    public void clear() {
        this.servicesRegistry.clear();
        this.packagesRegistry.clear();
    }

    public Set<String> getRegisteredTokens() {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        res.addAll(this.servicesRegistry.keySet());
        res.addAll(this.packagesRegistry.keySet());
        return res;
    }

    public List<String> getSelectedToken(TemplateCustomProperties customProperties) {
        ArrayList<String> res = new ArrayList<String>();
        for (String tokenName : this.getRegisteredTokens()) {
            boolean isSelected = true;
            block1: for (Map.Entry<String, List<String>> entry : this.getServices(tokenName).entrySet()) {
                String bundleName = entry.getKey();
                for (String className : entry.getValue()) {
                    if (bundleName.equals(customProperties.getServiceClasses().get(className))) continue;
                    isSelected = false;
                    continue block1;
                }
            }
            HashSet<String> packages = new HashSet<String>(customProperties.getPackagesURIs());
            for (String pkg : this.getPackages(tokenName)) {
                if (packages.contains(pkg)) continue;
                isSelected = false;
                break;
            }
            if (!isSelected) continue;
            res.add(tokenName);
        }
        return res;
    }

    public boolean canDeselectToken(TemplateCustomProperties customProperties, String tokenName) {
        this.deselectToken(customProperties, tokenName);
        boolean res = !this.getSelectedToken(customProperties).contains(tokenName);
        this.selectToken(customProperties, tokenName);
        return res;
    }

    public void selectToken(TemplateCustomProperties customProperties, String tokenName) {
        for (Map.Entry<String, List<String>> entry : this.getServices(tokenName).entrySet()) {
            String bundleName = entry.getKey();
            for (String cls : entry.getValue()) {
                customProperties.getServiceClasses().put(cls, bundleName);
            }
        }
        for (String nsURI : this.getPackages(tokenName)) {
            if (customProperties.getPackagesURIs().contains(nsURI)) continue;
            customProperties.getPackagesURIs().add(nsURI);
        }
    }

    public void deselectToken(TemplateCustomProperties customProperties, String tokenName) {
        List<String> selectedTokens = this.getSelectedToken(customProperties);
        selectedTokens.remove(tokenName);
        for (List<String> classes : this.getServices(tokenName).values()) {
            for (String cls : classes) {
                customProperties.getServiceClasses().remove(cls);
            }
        }
        customProperties.getPackagesURIs().removeAll(this.getPackages(tokenName));
        for (String token : selectedTokens) {
            this.selectToken(customProperties, token);
        }
    }
}

