/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.IIndexEntry2;
import org.eclipse.help.IIndexSee;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.eclipse.help.UAContentFilter;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpEvaluationContext;
import org.eclipse.help.internal.base.util.IndexUtils;
import org.eclipse.help.internal.index.IndexSee;
import org.eclipse.help.ui.internal.IHelpUIConstants;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.HyperlinkTreePart;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class IndexPart
extends HyperlinkTreePart
implements IHelpUIConstants {
    private RoleFilter roleFilter = new RoleFilter();

    public String getSeeString(IIndexSee see) {
        String seeText = see.isSeeAlso() ? Messages.SeeAlso : Messages.See;
        String message = NLS.bind((String)seeText, (Object)see.getKeyword());
        String[] path = IndexUtils.getPath((IIndexSee)see);
        int i = 1;
        while (i < path.length) {
            message = NLS.bind((String)Messages.SeeList, (Object)message, (Object)path[i]);
            ++i;
        }
        return message;
    }

    public IndexPart(Composite parent, FormToolkit toolkit, IToolBarManager tbm) {
        super(parent, toolkit, tbm);
    }

    @Override
    protected void configureTreeViewer() {
        this.treeViewer.setContentProvider((IContentProvider)new IndexProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new IndexLabelProvider());
    }

    @Override
    public void init(ReusableHelpPart parent, String id, IMemento memento) {
        super.init(parent, id, memento);
        if (parent.isFilteredByRoles()) {
            this.treeViewer.addFilter((ViewerFilter)this.roleFilter);
        }
    }

    @Override
    protected void doOpen(Object obj) {
        if (obj instanceof IHelpResource) {
            this.parent.showURL(((IHelpResource)obj).getHref());
        } else if (obj instanceof IIndexEntry) {
            ITopic[] topics;
            IIndexEntry entry = (IIndexEntry)obj;
            if (this.getChildren(entry).length > 0) {
                this.treeViewer.setExpandedState(obj, !this.treeViewer.getExpandedState(obj));
            }
            if ((topics = entry.getTopics()).length == 1) {
                this.parent.showURL(topics[0].getHref());
            }
        } else if (obj instanceof IIndexSee) {
            IIndexSee see = (IIndexSee)obj;
            IIndexEntry[] entrys = IndexUtils.findSeeTargets((IUAElement)HelpSystem.getIndex(), (IIndexSee)see, (int)0);
            int i = 0;
            while (i < entrys.length) {
                this.treeViewer.setExpandedState((Object)entrys[i], true);
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)entrys[i]), true);
                ++i;
            }
        }
    }

    @Override
    protected boolean canAddBookmarks() {
        return true;
    }

    @Override
    public void saveState(IMemento memento) {
    }

    @Override
    public void toggleRoleFilter() {
        if (this.parent.isFilteredByRoles()) {
            this.treeViewer.addFilter((ViewerFilter)this.roleFilter);
        } else {
            this.treeViewer.removeFilter((ViewerFilter)this.roleFilter);
        }
    }

    private Object[] getChildren(IIndexEntry entry) {
        IIndexSee[] sees;
        ITopic[] topics = entry.getTopics();
        IIndexEntry[] subentries = entry.getSubentries();
        IIndexSee[] iIndexSeeArray = sees = entry instanceof IIndexEntry2 ? ((IIndexEntry2)entry).getSees() : new IIndexSee[]{};
        if (topics.length <= 1 && subentries.length == 0 && sees.length == 0) {
            return new Object[0];
        }
        Object[] children = null;
        if (topics.length == 1) {
            children = new Object[subentries.length + sees.length];
            System.arraycopy(subentries, 0, children, 0, subentries.length);
            System.arraycopy(sees, 0, children, subentries.length, sees.length);
        } else {
            children = new Object[topics.length + subentries.length + sees.length];
            System.arraycopy(topics, 0, children, 0, topics.length);
            System.arraycopy(subentries, 0, children, topics.length, subentries.length);
            System.arraycopy(sees, 0, children, topics.length + subentries.length, sees.length);
        }
        return children;
    }

    protected Tree getTreeWidget() {
        return this.treeViewer.getTree();
    }

    class IndexLabelProvider
    extends LabelProvider {
        IndexLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof IIndexEntry) {
                return ((IIndexEntry)obj).getKeyword();
            }
            if (obj instanceof IHelpResource) {
                return ((IHelpResource)obj).getLabel();
            }
            if (obj instanceof IndexSee) {
                IndexSee see = (IndexSee)obj;
                return IndexPart.this.getSeeString((IIndexSee)see);
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            return super.getImage(obj);
        }
    }

    class IndexProvider
    implements ITreeContentProvider {
        IndexProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == IndexPart.this) {
                return HelpSystem.getIndex().getEntries();
            }
            if (parentElement instanceof IIndexEntry) {
                return IndexPart.this.getChildren((IIndexEntry)parentElement);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    static class RoleFilter
    extends ViewerFilter {
        RoleFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IIndexEntry) {
                return this.isEnabled((IIndexEntry)element);
            }
            if (element instanceof IHelpResource) {
                return this.isEnabled((IHelpResource)element);
            }
            if (element instanceof IIndexSee) {
                return this.isEnabled(element);
            }
            return false;
        }

        private boolean isEnabled(IIndexEntry entry) {
            if (!UAContentFilter.isFiltered((Object)entry, (IEvaluationContext)HelpEvaluationContext.getContext())) {
                ITopic[] topics = entry.getTopics();
                int i = 0;
                while (i < topics.length) {
                    if (this.isEnabled((IHelpResource)topics[i])) {
                        return true;
                    }
                    ++i;
                }
                IIndexEntry[] subentries = entry.getSubentries();
                int i2 = 0;
                while (i2 < subentries.length) {
                    if (this.isEnabled(subentries[i2])) {
                        return true;
                    }
                    ++i2;
                }
                if (entry instanceof IIndexEntry2) {
                    IIndexSee[] sees = ((IIndexEntry2)entry).getSees();
                    int i3 = 0;
                    while (i3 < sees.length) {
                        if (this.isEnabled(sees[i3])) {
                            return true;
                        }
                        ++i3;
                    }
                }
            }
            return false;
        }

        private boolean isEnabled(Object obj) {
            return !UAContentFilter.isFiltered((Object)obj, (IEvaluationContext)HelpEvaluationContext.getContext());
        }

        private boolean isEnabled(IHelpResource topic) {
            return this.isEnabled((Object)topic) && HelpBasePlugin.getActivitySupport().isEnabled(topic.getHref());
        }
    }
}

