/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Singleton;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.builder.impl.ToBeBuilt;

@Singleton
@Beta
public class ClosedProjectsQueue {
    private static final Logger log = Logger.getLogger(ClosedProjectsQueue.class);
    private static final int MAX_ATTEMPTS = Integer.getInteger("org.eclipse.xtext.builder.impl.ClosedProjectsQueue.MAX_ATTEMPTS", 10);
    private final Deque<Task> internalQueue = new ConcurrentLinkedDeque<Task>();

    public void enqueue(Set<String> projectNames, ToBeBuilt toBeBuilt) {
        this.internalQueue.addLast(new Task((ImmutableSet<String>)ImmutableSet.copyOf(projectNames), toBeBuilt));
    }

    public void insert(Set<String> projectNames, ToBeBuilt toBeBuilt, int attempt) {
        this.internalQueue.addFirst(new Task((ImmutableSet<String>)ImmutableSet.copyOf(projectNames), toBeBuilt, attempt));
    }

    public void insert(Set<String> projectNames, ToBeBuilt toBeBuilt) {
        this.internalQueue.addFirst(new Task((ImmutableSet<String>)ImmutableSet.copyOf(projectNames), toBeBuilt));
    }

    public Task exhaust() {
        LinkedHashSet projectNames = new LinkedHashSet();
        ToBeBuilt toBeBuilt = new ToBeBuilt();
        Set<URI> toBeDeleted = toBeBuilt.getToBeDeleted();
        Task next = this.internalQueue.poll();
        int attempt = 1;
        while (next != null) {
            attempt = Math.max(attempt, next.attempt);
            Set<URI> nextToBeDeleted = next.toBeBuilt.getToBeDeleted();
            if (nextToBeDeleted != null && !nextToBeDeleted.isEmpty()) {
                projectNames.addAll(next.projectNames);
                toBeDeleted.addAll(nextToBeDeleted);
            }
            next = this.internalQueue.poll();
        }
        return new Task((ImmutableSet<String>)ImmutableSet.copyOf(projectNames), toBeBuilt, attempt);
    }

    public class Task {
        private final ImmutableSet<String> projectNames;
        private final ToBeBuilt toBeBuilt;
        private final int attempt;

        protected Task(ImmutableSet<String> projectNames, ToBeBuilt toBeBuilt, int attempt) {
            this.projectNames = projectNames;
            this.toBeBuilt = toBeBuilt;
            this.attempt = attempt;
        }

        protected Task(ImmutableSet<String> projectNames, ToBeBuilt toBeBuilt) {
            this(projectNames, toBeBuilt, 1);
        }

        public boolean isEmpty() {
            return this.toBeBuilt.getToBeDeleted().isEmpty();
        }

        public void reschedule() {
            Set<URI> toBeDeleted = this.toBeBuilt.getToBeDeleted();
            if (toBeDeleted != null && !toBeDeleted.isEmpty()) {
                if (this.attempt > MAX_ATTEMPTS && MAX_ATTEMPTS > 0) {
                    log.error((Object)("Attempt to reschedule task more than " + this.attempt + " times."), new Throwable());
                } else {
                    ToBeBuilt scheduleMe = new ToBeBuilt();
                    scheduleMe.getToBeDeleted().addAll(toBeDeleted);
                    ClosedProjectsQueue.this.insert((Set<String>)this.projectNames, scheduleMe, this.attempt + 1);
                }
            }
        }

        public ImmutableSet<String> getProjectNames() {
            return this.projectNames;
        }

        public ToBeBuilt getToBeBuilt() {
            return this.toBeBuilt;
        }

        public int getAttempt() {
            return this.attempt;
        }
    }
}

