/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib.constraints;

import org.eclipse.comma.monitoring.lib.constraints.CConstraintValue;
import org.eclipse.comma.monitoring.lib.constraints.CStep;
import org.eclipse.comma.monitoring.lib.messages.CEnvironment;
import org.eclipse.comma.monitoring.lib.messages.CMessagePattern;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;
import org.eclipse.comma.monitoring.lib.utils.Utils;

public class CEventSelector
extends CStep {
    protected String timeVariable;
    protected String occurenceVariable = null;
    protected long occurenceCounter = 0L;
    protected boolean isNegated = false;
    protected int conditionIndex = 0;
    protected CMessagePattern event = null;

    public CEventSelector setTimeVariable(String vName) {
        this.timeVariable = vName;
        return this;
    }

    public CEventSelector setOccurenceVariable(String vName) {
        this.occurenceVariable = vName;
        return this;
    }

    public CEventSelector setNegated() {
        this.isNegated = true;
        return this;
    }

    public CEventSelector setConditionIndex(int i) {
        this.conditionIndex = i;
        return this;
    }

    public CEventSelector setEvent(CMessagePattern e) {
        this.event = e;
        return this;
    }

    CMessagePattern getEvent() {
        return this.event;
    }

    @Override
    public CConstraintValue consume(CObservedMessage message) {
        CEnvironment tempEnvironment = (CEnvironment)Utils.deepCopy(this.env);
        boolean eventsMatched = this.event.match(message, tempEnvironment);
        if (this.isNegated) {
            boolean bl = eventsMatched = !eventsMatched;
        }
        if (eventsMatched && this.conditionIndex > 0) {
            tempEnvironment.setVariableValue(this.timeVariable, message.getTimeDelta());
            eventsMatched = tempEnvironment.checkCondition(this.conditionIndex, message);
        }
        if (eventsMatched) {
            this.env.setVariableValue(this.timeVariable, message.getTimeDelta());
            if (!this.isNegated) {
                this.event.bindVariables(this.env, message);
            }
            if (this.occurenceVariable != null) {
                this.env.setVariableValue(this.occurenceVariable, ++this.occurenceCounter);
            }
            return CConstraintValue.TRUE;
        }
        return CConstraintValue.FALSE;
    }
}

