/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.propertypages;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.propertypages.JavaBreakpointAdvancedPage;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ThreadFilterEditor {
    private JavaBreakpointAdvancedPage fPage;
    private CheckboxTreeViewer fThreadViewer;
    private ThreadFilterContentProvider fContentProvider;
    private CheckHandler fCheckHandler;
    private static String MAIN = "main";

    public ThreadFilterEditor(Composite parent, JavaBreakpointAdvancedPage page) {
        this.fPage = page;
        this.fContentProvider = new ThreadFilterContentProvider();
        this.fCheckHandler = new CheckHandler();
        this.createThreadViewer(parent);
    }

    private void createThreadViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PropertyPageMessages.ThreadFilterEditor_1);
        label.setFont(parent.getFont());
        label.setLayoutData((Object)new GridData());
        GridData data = new GridData(1808);
        data.heightHint = 100;
        this.fThreadViewer = new CheckboxTreeViewer(parent, 2048);
        this.fThreadViewer.addCheckStateListener((ICheckStateListener)this.fCheckHandler);
        this.fThreadViewer.getTree().setLayoutData((Object)data);
        this.fThreadViewer.getTree().setFont(parent.getFont());
        this.fThreadViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fThreadViewer.setLabelProvider((IBaseLabelProvider)DebugUITools.newDebugModelPresentation());
        this.fThreadViewer.setInput((Object)DebugPlugin.getDefault().getLaunchManager());
        this.setInitialCheckedState();
    }

    protected void doStore() {
        IDebugTarget[] iDebugTargetArray = this.getDebugTargets();
        int n = iDebugTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                IDebugTarget debugTarget = iDebugTargetArray[n2];
                IJavaDebugTarget target = (IJavaDebugTarget)debugTarget.getAdapter(IJavaDebugTarget.class);
                if (target != null) {
                    try {
                        if (this.fThreadViewer.getChecked((Object)target)) {
                            IThread[] iThreadArray = target.getThreads();
                            int n3 = iThreadArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IThread targetThread = iThreadArray[n4];
                                IJavaThread thread = (IJavaThread)targetThread;
                                if (this.fThreadViewer.getChecked((Object)thread)) {
                                    this.fPage.getBreakpoint().setThreadFilter(thread);
                                    break block7;
                                }
                                ++n4;
                            }
                            break block7;
                        }
                        this.fPage.getBreakpoint().removeThreadFilter(target);
                    }
                    catch (CoreException e) {
                        JDIDebugUIPlugin.log(e);
                    }
                }
            }
            ++n2;
        }
    }

    protected void setInitialCheckedState() {
        try {
            IDebugTarget[] iDebugTargetArray = this.getDebugTargets();
            int n = iDebugTargetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaThread filteredThread;
                IDebugTarget debugTarget = iDebugTargetArray[n2];
                IJavaDebugTarget target = (IJavaDebugTarget)debugTarget.getAdapter(IJavaDebugTarget.class);
                if (target != null && (filteredThread = this.fPage.getBreakpoint().getThreadFilter(target)) != null) {
                    this.fCheckHandler.checkThread((IThread)filteredThread, true);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    protected IDebugTarget[] getDebugTargets() {
        Object input = this.fThreadViewer.getInput();
        if (!(input instanceof ILaunchManager)) {
            return new IJavaDebugTarget[0];
        }
        ILaunchManager launchManager = (ILaunchManager)input;
        return launchManager.getDebugTargets();
    }

    class CheckHandler
    implements ICheckStateListener {
        CheckHandler() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            if (element instanceof IDebugTarget) {
                this.checkTarget((IDebugTarget)element, event.getChecked());
            } else if (element instanceof IThread) {
                this.checkThread((IThread)element, event.getChecked());
            }
            this.verifyCheckedState();
        }

        protected void checkTarget(IDebugTarget target, boolean checked) {
            block11: {
                IThread[] threads;
                block12: {
                    IThread targetThread;
                    IThread[] threads2;
                    ThreadFilterEditor.this.fThreadViewer.setChecked((Object)target, checked);
                    if (!checked) break block12;
                    ThreadFilterEditor.this.fThreadViewer.expandToLevel((Object)target, -1);
                    try {
                        threads2 = target.getThreads();
                    }
                    catch (DebugException exception) {
                        JDIDebugUIPlugin.log(exception);
                        return;
                    }
                    boolean checkedThread = false;
                    IThread[] iThreadArray = threads2;
                    int n = threads2.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IThread thread = targetThread = iThreadArray[n2];
                        String name = null;
                        try {
                            name = thread.getName();
                        }
                        catch (DebugException exception) {
                            JDIDebugUIPlugin.log(exception);
                        }
                        if (MAIN.equals(name)) {
                            checkedThread = ThreadFilterEditor.this.fThreadViewer.setChecked((Object)thread, true);
                        }
                        ++n2;
                    }
                    if (checkedThread) break block11;
                    iThreadArray = threads2;
                    n = threads2.length;
                    n2 = 0;
                    while (n2 < n) {
                        targetThread = iThreadArray[n2];
                        if (!ThreadFilterEditor.this.fThreadViewer.setChecked((Object)targetThread, true)) {
                            ++n2;
                            continue;
                        }
                        break block11;
                    }
                    break block11;
                }
                try {
                    threads = target.getThreads();
                }
                catch (DebugException exception) {
                    JDIDebugUIPlugin.log(exception);
                    return;
                }
                IThread[] iThreadArray = threads;
                int n = threads.length;
                int n3 = 0;
                while (n3 < n) {
                    IThread thread = iThreadArray[n3];
                    ThreadFilterEditor.this.fThreadViewer.setChecked((Object)thread, false);
                    ++n3;
                }
            }
        }

        protected void checkThread(IThread thread, boolean checked) {
            ThreadFilterEditor.this.fThreadViewer.setChecked((Object)thread, checked);
            IDebugTarget target = thread.getDebugTarget();
            if (checked) {
                IThread[] threads;
                if (!ThreadFilterEditor.this.fThreadViewer.getChecked((Object)target)) {
                    ThreadFilterEditor.this.fThreadViewer.setChecked((Object)target, true);
                }
                try {
                    threads = target.getThreads();
                }
                catch (DebugException exception) {
                    JDIDebugUIPlugin.log(exception);
                    return;
                }
                IThread[] iThreadArray = threads;
                int n = threads.length;
                int n2 = 0;
                while (n2 < n) {
                    IThread targetThread = iThreadArray[n2];
                    if (targetThread != thread) {
                        ThreadFilterEditor.this.fThreadViewer.setChecked((Object)targetThread, false);
                    }
                    ++n2;
                }
            } else {
                ThreadFilterEditor.this.fThreadViewer.setChecked((Object)target, false);
            }
        }

        protected void verifyCheckedState() {
            IDebugTarget[] targets;
            IDebugTarget[] iDebugTargetArray = targets = ThreadFilterEditor.this.getDebugTargets();
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                block8: {
                    IDebugTarget debugTarget = iDebugTargetArray[n2];
                    IDebugTarget target = debugTarget;
                    if (ThreadFilterEditor.this.fThreadViewer.getChecked((Object)target)) {
                        IThread[] threads;
                        try {
                            threads = target.getThreads();
                        }
                        catch (DebugException exception) {
                            JDIDebugUIPlugin.log(exception);
                            break block8;
                        }
                        boolean checkedThread = false;
                        IThread[] iThreadArray = threads;
                        int n3 = threads.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IThread thread = iThreadArray[n4];
                            if (ThreadFilterEditor.this.fThreadViewer.getChecked((Object)thread)) {
                                checkedThread = true;
                                break;
                            }
                            ++n4;
                        }
                        if (checkedThread) {
                            ThreadFilterEditor.this.fPage.setErrorMessage(null);
                        } else {
                            ThreadFilterEditor.this.fPage.setErrorMessage(PropertyPageMessages.ThreadFilterEditor_2);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    class ThreadFilterContentProvider
    implements ITreeContentProvider {
        ThreadFilterContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            IJavaDebugTarget target;
            if (parent instanceof IDebugTarget && (target = (IJavaDebugTarget)((IDebugTarget)parent).getAdapter(IJavaDebugTarget.class)) != null) {
                try {
                    return ((IJavaDebugTarget)parent).getThreads();
                }
                catch (DebugException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
            if (parent instanceof ILaunchManager) {
                ILaunch[] launches;
                ArrayList<IJavaDebugTarget> children = new ArrayList<IJavaDebugTarget>();
                ILaunch[] iLaunchArray = launches = ((ILaunchManager)parent).getLaunches();
                int n = launches.length;
                int n2 = 0;
                while (n2 < n) {
                    IDebugTarget[] targets;
                    ILaunch launch = iLaunchArray[n2];
                    IDebugTarget[] iDebugTargetArray = targets = launch.getDebugTargets();
                    int n3 = targets.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IDebugTarget debugTarget = iDebugTargetArray[n4];
                        IJavaDebugTarget target2 = (IJavaDebugTarget)debugTarget.getAdapter(IJavaDebugTarget.class);
                        if (target2 != null && !target2.isDisconnected() && !target2.isTerminated()) {
                            children.add(target2);
                        }
                        ++n4;
                    }
                    ++n2;
                }
                return children.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IThread) {
                return ((IThread)element).getDebugTarget();
            }
            if (element instanceof IDebugTarget) {
                return ((IDebugElement)element).getLaunch();
            }
            if (element instanceof ILaunch) {
                return DebugPlugin.getDefault().getLaunchManager();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IStackFrame) {
                return false;
            }
            if (element instanceof IDebugElement) {
                return this.getChildren(element).length > 0;
            }
            if (element instanceof ILaunch) {
                return true;
            }
            if (element instanceof ILaunchManager) {
                return ((ILaunchManager)element).getLaunches().length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

