/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.behavior.validation;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.comma.actions.actions.ActionsPackage;
import org.eclipse.comma.actions.actions.VariableDeclBlock;
import org.eclipse.comma.behavior.behavior.AbstractBehavior;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.validation.DataConstraintsValidator;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class BehaviorValidator
extends DataConstraintsValidator {
    public static final String STATEMACHINE_DUPLICATE_INTERFACE = "statemachine_duplicate_interface";
    public static final String STATEMACHINE_UNUSED_INTERFACE = "statemachine_unused_interface";
    public static final String STATEMACHINE_DUPLICATE_STATE = "statemachine_duplicate_state";
    public static final String STATEMACHINE_DUPLICATE_VAR = "statemachine_duplicate_var";
    public static final String STATEMACHINE_UNITIALIZED_VAR = "statemachine_uninitialized_var";
    public static final String STATEMACHINE_UNUSED_VAR = "statemachine_unused_var";

    @Check
    public void checkNotInitializedVariables(VariableDeclBlock block) {
        if (block instanceof AbstractBehavior) {
            super.checkNotInitializedVariables(block);
        }
    }

    @Check
    public void checkDuplicatedMachineNames(AbstractBehavior spec) {
        this.checkForNameDuplications((Iterable)spec.getMachines(), "state machine", null, new String[0]);
    }

    @Check
    public void checkDuplicateStateNames(AbstractBehavior spec) {
        Functions.Function1<StateMachine, EList<State>> _function = new Functions.Function1<StateMachine, EList<State>>(){

            public EList<State> apply(StateMachine it) {
                return it.getStates();
            }
        };
        this.checkForNameDuplications(Iterables.concat((Iterable)ListExtensions.map(spec.getMachines(), (Functions.Function1)_function)), "state", null, new String[0]);
    }

    @Check
    public void checkDuplicatePCFragmentNames(AbstractBehavior spec) {
        this.checkForNameDuplications((Iterable)spec.getFragments(), "event fragment", null, new String[0]);
    }

    @Check
    public void checkUnusedGlobalVariables(AbstractBehavior spec) {
        ArrayList variables = new ArrayList();
        variables.addAll(spec.getVars());
        Functions.Function1<ExpressionVariable, Variable> _function = new Functions.Function1<ExpressionVariable, Variable>(){

            public Variable apply(ExpressionVariable it) {
                return it.getVariable();
            }
        };
        variables.removeAll(ListExtensions.map((List)EcoreUtil2.getAllContentsOfType((EObject)spec, ExpressionVariable.class), (Functions.Function1)_function));
        for (Variable v : variables) {
            this.warning("Unused variable.", (EStructuralFeature)ActionsPackage.Literals.VARIABLE_DECL_BLOCK__VARS, spec.getVars().indexOf((Object)v));
        }
    }
}

