/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ant.internal.ui.editor.AntEditor;
import org.eclipse.ant.internal.ui.editor.text.XMLTextHover;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModel;
import org.eclipse.ant.internal.ui.model.IAntElement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;

public class OccurrencesFinder {
    private AntModel fAntModel;
    private AntEditor fEditor;
    private int fOffset;
    private IDocument fDocument;

    public OccurrencesFinder(AntEditor editor, AntModel model, IDocument document, int offset) {
        this.fAntModel = model;
        this.fEditor = editor;
        this.fDocument = document;
        this.fOffset = offset;
    }

    public List<Position> perform() {
        String identifier;
        AntElementNode node;
        if (this.fOffset == 0 || this.fAntModel == null) {
            return null;
        }
        AntElementNode container = this.fAntModel.getNode(this.fOffset, false);
        if (container == null) {
            return null;
        }
        IRegion region = XMLTextHover.getRegion((ITextViewer)this.fEditor.getViewer(), this.fOffset);
        if (region != null && !container.isRegionPotentialReference(region)) {
            return null;
        }
        if (container.isFromDeclaration(region)) {
            node = container;
        } else {
            Object potentialNode = this.fEditor.findTarget(region);
            if (!(potentialNode instanceof AntElementNode)) {
                return null;
            }
            node = (AntElementNode)potentialNode;
        }
        String occurrencesIdentifier = node.getOccurrencesIdentifier();
        if (occurrencesIdentifier == null) {
            return null;
        }
        ArrayList<IAntElement> nodes = new ArrayList<IAntElement>(1);
        nodes.add(this.fAntModel.getProjectNode());
        ArrayList<IAntElement> usages = new ArrayList<IAntElement>();
        usages.add(node);
        this.scanNodesForOccurrences(nodes, usages, occurrencesIdentifier);
        try {
            identifier = this.fDocument.get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        int length = identifier.length();
        if (length == 0) {
            return null;
        }
        ArrayList<Position> positions = new ArrayList<Position>(usages.size());
        for (IAntElement currentNode : usages) {
            List<Integer> offsets = currentNode.computeIdentifierOffsets(identifier);
            if (offsets == null) continue;
            for (Integer offset : offsets) {
                positions.add(new Position(offset.intValue(), length));
            }
        }
        return positions;
    }

    private void scanNodesForOccurrences(List<IAntElement> nodes, List<IAntElement> usages, String identifier) {
        for (IAntElement node : nodes) {
            if (!usages.contains(node) && node.containsOccurrence(identifier)) {
                usages.add(node);
            }
            if (!node.hasChildren()) continue;
            this.scanNodesForOccurrences(node.getChildNodes(), usages, identifier);
        }
    }
}

