/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.FloatSet;
import org.eclipse.collections.api.set.primitive.ImmutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractSynchronizedFloatCollection;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;

public final class SynchronizedFloatSet
extends AbstractSynchronizedFloatCollection
implements MutableFloatSet {
    private static final long serialVersionUID = 1L;

    public SynchronizedFloatSet(MutableFloatSet set) {
        super(set);
    }

    public SynchronizedFloatSet(MutableFloatSet set, Object newLock) {
        super(set, newLock);
    }

    public static SynchronizedFloatSet of(MutableFloatSet set) {
        return new SynchronizedFloatSet(set);
    }

    public static SynchronizedFloatSet of(MutableFloatSet set, Object lock) {
        return new SynchronizedFloatSet(set, lock);
    }

    private MutableFloatSet getMutableFloatSet() {
        return (MutableFloatSet)this.getFloatCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedFloatSet without(float element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatSet().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedFloatSet with(float element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatSet().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedFloatSet withAll(FloatIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatSet().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedFloatSet withoutAll(FloatIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatSet().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatSet select(FloatPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatSet().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatSet reject(FloatPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatSet().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableSet<V> collect(FloatToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatSet().collect((FloatToObjectFunction)function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object otherSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatSet().equals(otherSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatSet().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyFloatIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyFloatIterableAdapter(this);
        }
    }

    @Override
    public MutableFloatSet asUnmodifiable() {
        return new UnmodifiableFloatSet(this);
    }

    @Override
    public MutableFloatSet asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FloatSet freeze() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatSet().freeze();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableFloatSet toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatSet().toImmutable();
        }
    }
}

