/*
 * Copyright (c) 2021 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

/**
 * This package contains implementations of immutable sets with user defined {@link org.eclipse.collections.api.block.HashingStrategy}s.
 * <p>
 *     This package contains the following implementations:
 * <ul>
 *     <li>
 *          {@link org.eclipse.collections.impl.set.strategy.immutable.ImmutableEmptySetWithHashingStrategy} - an {@link org.eclipse.collections.impl.set.immutable.ImmutableEmptySet} with user defined hashing strategy.
 *     </li>
 *     <li>
 *          {@link org.eclipse.collections.impl.set.strategy.immutable.ImmutableUnifiedSetWithHashingStrategy} - an {@link org.eclipse.collections.impl.set.immutable.ImmutableUnifiedSet} with user defined hashing strategy.
 *     </li>
 * </ul>
 * <p>
 *     This package contains one factory implementation:
 * <ul>
 *     <li>
 *          {@link org.eclipse.collections.impl.set.strategy.immutable.ImmutableHashingStrategySetFactoryImpl} - a factory which creates instances of type {@link org.eclipse.collections.api.set.ImmutableSet} with user defined hashing strategy.
 *     </li>
 * </ul>
 */
package org.eclipse.collections.impl.set.strategy.immutable;
