/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.model.core.support;

import java.util.List;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeakIntensityValues;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.implementation.PeakIntensityValues;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.chemclipse.model.signals.TotalScanSignalsModifier;
import org.eclipse.chemclipse.model.support.BackgroundAbundanceRange;
import org.eclipse.chemclipse.model.support.IBackgroundAbundanceRange;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.equations.Equations;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramPeakWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.IPeakModelWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.chemclipse.wsd.model.core.implementation.ChromatogramPeakWSD;
import org.eclipse.chemclipse.wsd.model.core.implementation.PeakModelWSD;
import org.eclipse.chemclipse.wsd.model.core.implementation.ScanWSD;

public class PeakBuilderWSD {
    public static IChromatogramPeakWSD createPeak(IChromatogramWSD chromatogram, IScanRange scanRange, boolean calculatePeakIncludedBackground) throws PeakException {
        BackgroundAbundanceRange backgroundAbundanceRange;
        PeakBuilderWSD.validateChromatogram(chromatogram);
        PeakBuilderWSD.validateScanRange(scanRange);
        PeakBuilderWSD.checkScanRange(chromatogram, scanRange);
        ITotalScanSignals totalScanSignals = PeakBuilderWSD.getTotalScanSignals(chromatogram, scanRange);
        ITotalScanSignal totalScanSignal = totalScanSignals.getTotalScanSignal(scanRange.getStartScan());
        float startBackgroundAbundance = totalScanSignal.getTotalSignal();
        totalScanSignal = totalScanSignals.getTotalScanSignal(scanRange.getStopScan());
        float stopBackgroundAbundance = totalScanSignal.getTotalSignal();
        if (calculatePeakIncludedBackground) {
            backgroundAbundanceRange = new BackgroundAbundanceRange(startBackgroundAbundance, stopBackgroundAbundance);
        } else {
            float base = Math.min(startBackgroundAbundance, stopBackgroundAbundance);
            backgroundAbundanceRange = new BackgroundAbundanceRange(base, base);
        }
        LinearEquation backgroundEquation = PeakBuilderWSD.getBackgroundEquation(totalScanSignals, scanRange, (IBackgroundAbundanceRange)backgroundAbundanceRange);
        ITotalScanSignals peakIntensityTotalScanSignals = PeakBuilderWSD.adjustTotalScanSignals(totalScanSignals, backgroundEquation);
        IPeakIntensityValues peakIntensityValues = PeakBuilderWSD.getPeakIntensityValues(peakIntensityTotalScanSignals);
        IScanWSD peakScanWSD = PeakBuilderWSD.getPeakScan(chromatogram, totalScanSignals, backgroundEquation);
        PeakModelWSD peakModel = new PeakModelWSD(peakScanWSD, peakIntensityValues, backgroundAbundanceRange.getStartBackgroundAbundance(), backgroundAbundanceRange.getStopBackgroundAbundance());
        ChromatogramPeakWSD peak = new ChromatogramPeakWSD((IPeakModelWSD)peakModel, chromatogram);
        return peak;
    }

    public static IChromatogramPeakWSD createPeak(IChromatogramWSD chromatogram, IScanRange scanRange, IBackgroundAbundanceRange backgroundAbundanceRange, boolean checkBackgroundAbundanceRange) throws PeakException {
        PeakBuilderWSD.validateChromatogram(chromatogram);
        PeakBuilderWSD.validateScanRange(scanRange);
        PeakBuilderWSD.validateBackgroundAbundanceRange(backgroundAbundanceRange);
        ITotalScanSignals totalScanSignals = PeakBuilderWSD.getTotalScanSignals(chromatogram, scanRange);
        if (checkBackgroundAbundanceRange) {
            backgroundAbundanceRange = PeakBuilderWSD.checkBackgroundAbundanceRange(totalScanSignals, scanRange, backgroundAbundanceRange);
        }
        LinearEquation backgroundEquation = PeakBuilderWSD.getBackgroundEquation(totalScanSignals, scanRange, backgroundAbundanceRange);
        ITotalScanSignals peakIntensityTotalIonSignals = PeakBuilderWSD.adjustTotalScanSignals(totalScanSignals, backgroundEquation);
        IPeakIntensityValues peakIntensityValues = PeakBuilderWSD.getPeakIntensityValues(peakIntensityTotalIonSignals);
        IScanWSD peakScanWSD = PeakBuilderWSD.getPeakScan(chromatogram, totalScanSignals, backgroundEquation);
        PeakModelWSD peakModel = new PeakModelWSD(peakScanWSD, peakIntensityValues, backgroundAbundanceRange.getStartBackgroundAbundance(), backgroundAbundanceRange.getStopBackgroundAbundance());
        ChromatogramPeakWSD peak = new ChromatogramPeakWSD((IPeakModelWSD)peakModel, chromatogram);
        return peak;
    }

    protected static void validateChromatogram(IChromatogramWSD chromatogram) throws PeakException {
        if (chromatogram == null) {
            throw new PeakException("The chromatogram must not be null.");
        }
    }

    protected static void validateScanRange(IScanRange scanRange) throws PeakException {
        if (scanRange == null) {
            throw new PeakException("The scan range must not be null.");
        }
    }

    protected static void checkScanRange(IChromatogramWSD chromatogram, IScanRange scanRange) throws PeakException {
        assert (chromatogram != null) : "The chromatogram must not be null.";
        assert (scanRange != null) : "The scan range must not be null.";
        if (chromatogram == null || scanRange == null) {
            throw new PeakException("The given chromatogram or scanRange must not be null.");
        }
        if (scanRange.getStartScan() < 1 || scanRange.getStopScan() > chromatogram.getNumberOfScans()) {
            throw new PeakException("The given scan range is out of chromatogram borders.");
        }
    }

    protected static ITotalScanSignals getTotalScanSignals(IChromatogramWSD chromatogram, IScanRange scanRange) throws PeakException {
        assert (chromatogram != null) : "The chromatogram must not be null.";
        assert (scanRange != null) : "The scan range must not be null.";
        if (chromatogram == null || scanRange == null) {
            throw new PeakException("The given values must not be null.");
        }
        try {
            TotalScanSignalExtractor totalScanSignalExtractor = new TotalScanSignalExtractor((IChromatogram)chromatogram);
            return totalScanSignalExtractor.getTotalScanSignals(scanRange.getStartScan(), scanRange.getStopScan());
        }
        catch (ChromatogramIsNullException e) {
            throw new PeakException("The chromatogram must not be null.");
        }
    }

    protected static LinearEquation getBackgroundEquation(ITotalScanSignals totalScanSignals, IScanRange scanRange, IBackgroundAbundanceRange backgroundAbundanceRange) throws PeakException {
        assert (totalScanSignals != null) : "The total ion signals must not be null.";
        assert (scanRange != null) : "The scan range must not be null.";
        assert (backgroundAbundanceRange != null) : "The background abundance range must not be null.";
        if (totalScanSignals == null || scanRange == null || backgroundAbundanceRange == null) {
            throw new PeakException("The given totalIonSignals, scanRange or backgroundAbundanceRange must not be null.");
        }
        ITotalScanSignal totalScanSignal = totalScanSignals.getTotalScanSignal(scanRange.getStartScan());
        Point p1 = new Point((double)totalScanSignal.getRetentionTime(), (double)backgroundAbundanceRange.getStartBackgroundAbundance());
        totalScanSignal = totalScanSignals.getTotalScanSignal(scanRange.getStopScan());
        Point p2 = new Point((double)totalScanSignal.getRetentionTime(), (double)backgroundAbundanceRange.getStopBackgroundAbundance());
        LinearEquation backgroundEquation = Equations.createLinearEquation((IPoint)p1, (IPoint)p2);
        return backgroundEquation;
    }

    protected static ITotalScanSignals adjustTotalScanSignals(ITotalScanSignals totalScanSignals, LinearEquation backgroundEquation) throws PeakException {
        assert (totalScanSignals != null) : "The total ion signals must not be null.";
        assert (backgroundEquation != null) : "The background equation must not be null.";
        if (totalScanSignals == null || backgroundEquation == null) {
            throw new PeakException("The given totalIonSignals or backgroundEquation must not be null.");
        }
        ITotalScanSignals peakIntensityTotalScanSignals = totalScanSignals.makeDeepCopy();
        int start = peakIntensityTotalScanSignals.getStartScan();
        int stop = peakIntensityTotalScanSignals.getStopScan();
        int scan = start;
        while (scan <= stop) {
            ITotalScanSignal totalScanSignal = peakIntensityTotalScanSignals.getTotalScanSignal(scan);
            float adjustedSignal = (float)((double)totalScanSignal.getTotalSignal() - backgroundEquation.calculateY((double)totalScanSignal.getRetentionTime()));
            if (adjustedSignal < 0.0f) {
                adjustedSignal = 0.0f;
            }
            totalScanSignal.setTotalSignal(adjustedSignal);
            ++scan;
        }
        TotalScanSignalsModifier.normalize((ITotalScanSignals)peakIntensityTotalScanSignals, (float)100.0f);
        return peakIntensityTotalScanSignals;
    }

    protected static IPeakIntensityValues getPeakIntensityValues(ITotalScanSignals peakIntensityTotalIonSignals) throws PeakException {
        assert (peakIntensityTotalIonSignals != null) : "The peak intensity total ion signals must not be null.";
        if (peakIntensityTotalIonSignals == null) {
            throw new PeakException("The peakIntensityTotalIonSignals must not be null.");
        }
        PeakIntensityValues peakIntensityValues = new PeakIntensityValues();
        List signals = peakIntensityTotalIonSignals.getTotalScanSignals();
        for (ITotalScanSignal signal : signals) {
            peakIntensityValues.addIntensityValue(signal.getRetentionTime(), signal.getTotalSignal());
        }
        return peakIntensityValues;
    }

    private static IScanWSD getPeakScan(IChromatogramWSD chromatogram, ITotalScanSignals totalScanSignals, LinearEquation backgroundEquation) {
        if (chromatogram == null || totalScanSignals == null || backgroundEquation == null) {
            throw new PeakException("The chromatogram, totalScanSignals or backgroundEquation must not be null.");
        }
        ScanWSD peakScanWSD = null;
        ITotalScanSignal totalScanSignal = totalScanSignals.getMaxTotalScanSignal();
        if (totalScanSignal != null) {
            int scan = chromatogram.getScanNumber(totalScanSignal.getRetentionTime());
            IScanWSD scanWSD = chromatogram.getSupplierScan(scan);
            float actualSignal = scanWSD.getTotalSignal();
            float backgroundSignal = (float)backgroundEquation.calculateY((double)totalScanSignal.getRetentionTime());
            float correctedSignal = actualSignal - backgroundSignal;
            float percentage = 100.0f / correctedSignal * actualSignal;
            peakScanWSD = new ScanWSD(scanWSD, percentage);
        }
        return peakScanWSD;
    }

    protected static void validateBackgroundAbundanceRange(IBackgroundAbundanceRange backgroundAbundanceRange) throws PeakException {
        if (backgroundAbundanceRange == null) {
            throw new PeakException("The background abundance range must not be null.");
        }
    }

    protected static IBackgroundAbundanceRange checkBackgroundAbundanceRange(ITotalScanSignals totalScanSignals, IScanRange scanRange, IBackgroundAbundanceRange backgroundAbundanceRange) throws PeakException {
        float background = 0.0f;
        float signal = 0.0f;
        float startBackgroundAbundance = 0.0f;
        float stopBackgroundAbundance = 0.0f;
        boolean adjustBackgroundAbundance = false;
        if (totalScanSignals == null || scanRange == null || backgroundAbundanceRange == null) {
            throw new PeakException("The given values must not be null.");
        }
        ITotalScanSignal totalScanSignal = totalScanSignals.getTotalScanSignal(scanRange.getStartScan());
        if (totalScanSignal != null) {
            background = backgroundAbundanceRange.getStartBackgroundAbundance();
            if (background <= (signal = totalScanSignal.getTotalSignal())) {
                startBackgroundAbundance = background;
            } else {
                startBackgroundAbundance = signal;
                adjustBackgroundAbundance = true;
            }
        } else {
            adjustBackgroundAbundance = true;
        }
        totalScanSignal = totalScanSignals.getTotalScanSignal(scanRange.getStopScan());
        if (totalScanSignal != null) {
            background = backgroundAbundanceRange.getStopBackgroundAbundance();
            if (background <= (signal = totalScanSignal.getTotalSignal())) {
                stopBackgroundAbundance = background;
            } else {
                stopBackgroundAbundance = signal;
                adjustBackgroundAbundance = true;
            }
        } else {
            adjustBackgroundAbundance = true;
        }
        if (adjustBackgroundAbundance) {
            backgroundAbundanceRange = new BackgroundAbundanceRange(startBackgroundAbundance, stopBackgroundAbundance);
        }
        return backgroundAbundanceRange;
    }
}

