/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.handlers;

import org.eclipse.chemclipse.support.settings.OperatingSystemUtils;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;

public class CreateSnapshotHandler {
    private Clipboard clipboard = new Clipboard(DisplayUtils.getDisplay());

    @Execute
    public void execute(Composite composite) {
        this.copyCompositeToClipboard(composite);
    }

    private void copyCompositeToClipboard(Composite composite) {
        Image image = this.getImage(composite);
        if (image == null) {
            this.openMessageBox("The focus of the selected view/editor couldn't be retrieved.");
        } else if (OperatingSystemUtils.isLinux()) {
            FileDialog fileDialog = new FileDialog(DisplayUtils.getShell(), 8192);
            fileDialog.setText("Save Clipboard To File");
            fileDialog.setFileName("Clipboard.png");
            fileDialog.setFilterExtensions(new String[]{"*.png"});
            fileDialog.setOverwrite(true);
            fileDialog.setFilterNames(new String[]{" PNG (*.png)"});
            String file = fileDialog.open();
            if (file != null && !file.equals("")) {
                ImageLoader imageLoader = new ImageLoader();
                imageLoader.data = new ImageData[]{image.getImageData()};
                imageLoader.save(file, 5);
            }
        } else {
            ImageTransfer imageTransfer = ImageTransfer.getInstance();
            Object[] data = new Object[]{image.getImageData()};
            Transfer[] dataTypes = new Transfer[]{imageTransfer};
            this.clipboard.setContents(data, dataTypes);
            this.openMessageBox("The selected view/editor has been copied to clipboard.");
        }
    }

    private Image getImage(Composite composite) {
        Image image = null;
        if (composite != null && composite.getParent() != null) {
            Composite compositeParent = composite.getParent();
            GC gc = null;
            try {
                gc = new GC((Drawable)compositeParent);
                image = new Image((Device)DisplayUtils.getDisplay(), compositeParent.getBounds());
                gc.copyArea(image, 0, 0);
            }
            finally {
                if (gc != null) {
                    gc.dispose();
                }
            }
        }
        return image;
    }

    private void openMessageBox(String message) {
        String text = "Copy Selection To Clipboard";
        MessageBox messageBox = new MessageBox(DisplayUtils.getShell(), 0);
        messageBox.setText(text);
        messageBox.setMessage(message);
        messageBox.open();
    }
}

