/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.swt;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.ux.extension.msd.ui.internal.provider.BarSeriesIon;
import org.eclipse.chemclipse.ux.extension.msd.ui.internal.provider.BarSeriesIonComparator;
import org.eclipse.chemclipse.ux.extension.msd.ui.internal.provider.UpdateMenuEntry;
import org.eclipse.chemclipse.ux.extension.msd.ui.swt.IMassSpectrumChart;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.axisconverter.PercentageConverter;
import org.eclipse.swtchart.extensions.barcharts.BarChart;
import org.eclipse.swtchart.extensions.barcharts.BarSeriesData;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.IPrimaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.RangeRestriction;
import org.eclipse.swtchart.extensions.core.SecondaryAxisSettings;
import org.eclipse.swtchart.extensions.core.SeriesData;
import org.eclipse.swtchart.extensions.menu.IChartMenuEntry;

public class MassSpectrumChartCentroid
extends BarChart
implements IMassSpectrumChart {
    private static final int MAX_NUMBER_MZ = 50000;
    private static final DecimalFormat DEFAULT_DECIMAL_FORMAT = new DecimalFormat();
    private int numberOfHighestIntensitiesToLabel;
    private BarSeriesIonComparator barSeriesIonComparator;
    private LabelOption labelOption;
    private Map<Double, String> customLabels;
    private IScanMSD massSpectrum = null;

    public MassSpectrumChartCentroid() {
        this.initialize();
    }

    public MassSpectrumChartCentroid(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    @Override
    public void update(IScanMSD massSpectrum) {
        this.massSpectrum = massSpectrum;
        this.update();
    }

    @Override
    public void update() {
        this.deleteSeries();
        if (this.massSpectrum != null) {
            ArrayList<BarSeriesData> barSeriesDataList = new ArrayList<BarSeriesData>();
            ISeriesData seriesData = this.getMassSpectrum(this.massSpectrum);
            BarSeriesData barSeriesData = new BarSeriesData(seriesData);
            barSeriesDataList.add(barSeriesData);
            this.addSeriesData(barSeriesDataList, 50000);
        }
    }

    private void initialize() {
        this.numberOfHighestIntensitiesToLabel = 5;
        this.barSeriesIonComparator = new BarSeriesIonComparator();
        this.labelOption = LabelOption.EXACT;
        this.customLabels = new HashMap<Double, String>();
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.setOrientation(256);
        chartSettings.setHorizontalSliderVisible(true);
        chartSettings.setVerticalSliderVisible(true);
        chartSettings.setCreateMenu(true);
        chartSettings.addMenuEntry((IChartMenuEntry)new UpdateMenuEntry());
        RangeRestriction rangeRestriction = chartSettings.getRangeRestriction();
        rangeRestriction.setZeroX(false);
        rangeRestriction.setZeroY(false);
        rangeRestriction.setRestrictZoom(true);
        rangeRestriction.setExtendTypeX(RangeRestriction.ExtendType.ABSOLUTE);
        rangeRestriction.setExtendMinX(2.0);
        rangeRestriction.setExtendMaxX(2.0);
        rangeRestriction.setExtendTypeY(RangeRestriction.ExtendType.RELATIVE);
        rangeRestriction.setExtendMaxY(0.1);
        this.setPrimaryAxisSet(chartSettings);
        this.addSecondaryAxisSet(chartSettings);
        this.applySettings(chartSettings);
        this.addSeriesLabelMarker();
    }

    private void setPrimaryAxisSet(IChartSettings chartSettings) {
        IPrimaryAxisSettings primaryAxisSettingsX = chartSettings.getPrimaryAxisSettingsX();
        primaryAxisSettingsX.setTitle("m/z");
        primaryAxisSettingsX.setDecimalFormat(new DecimalFormat("0.0##", new DecimalFormatSymbols(Locale.ENGLISH)));
        primaryAxisSettingsX.setColor(this.getDisplay().getSystemColor(2));
        IPrimaryAxisSettings primaryAxisSettingsY = chartSettings.getPrimaryAxisSettingsY();
        primaryAxisSettingsY.setTitle("Intensity");
        primaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.0#E0", new DecimalFormatSymbols(Locale.ENGLISH)));
        primaryAxisSettingsY.setColor(this.getDisplay().getSystemColor(2));
    }

    private void addSecondaryAxisSet(IChartSettings chartSettings) {
        SecondaryAxisSettings secondaryAxisSettingsY = new SecondaryAxisSettings("Relative Intensity [%]", (IAxisScaleConverter)new PercentageConverter(512, true));
        secondaryAxisSettingsY.setPosition(IAxis.Position.Secondary);
        secondaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.ENGLISH)));
        secondaryAxisSettingsY.setColor(this.getDisplay().getSystemColor(2));
        chartSettings.getSecondaryAxisSettingsListY().add(secondaryAxisSettingsY);
    }

    private void addSeriesLabelMarker() {
        IPlotArea plotArea = this.getBaseChart().getPlotArea();
        plotArea.addCustomPaintListener(new ICustomPaintListener(){

            public void paintControl(PaintEvent e) {
                BarSeriesIon barSeriesIon;
                List barSeriesIons = MassSpectrumChartCentroid.this.getBarSeriesIonList();
                Collections.sort(barSeriesIons, MassSpectrumChartCentroid.this.barSeriesIonComparator);
                int barSeriesSize = barSeriesIons.size();
                int limit = MassSpectrumChartCentroid.this.numberOfHighestIntensitiesToLabel;
                int i = 0;
                while (i < limit) {
                    if (i < barSeriesSize) {
                        barSeriesIon = (BarSeriesIon)barSeriesIons.get(i);
                        MassSpectrumChartCentroid.this.printLabel(barSeriesIon, e);
                    }
                    ++i;
                }
                limit = barSeriesIons.size() - MassSpectrumChartCentroid.this.numberOfHighestIntensitiesToLabel;
                limit = limit < 0 ? 0 : limit;
                i = barSeriesIons.size() - 1;
                while (i >= limit) {
                    barSeriesIon = (BarSeriesIon)barSeriesIons.get(i);
                    if (barSeriesIon.getIntensity() < 0.0) {
                        MassSpectrumChartCentroid.this.printLabel(barSeriesIon, e);
                    }
                    --i;
                }
            }

            public boolean drawBehindSeries() {
                return false;
            }
        });
    }

    private void printLabel(BarSeriesIon barSeriesIon, PaintEvent e) {
        Point point = barSeriesIon.getPoint();
        String label = this.getLabel(barSeriesIon.getMz());
        boolean negative = barSeriesIon.getIntensity() < 0.0;
        Point labelSize = e.gc.textExtent(label);
        int x = (int)((double)point.x + 0.5 - (double)labelSize.x / 2.0);
        int y = point.y;
        if (!negative) {
            y = point.y - labelSize.y;
        }
        e.gc.drawText(label, x, y, true);
    }

    private String getLabel(double mz) {
        String label;
        switch (this.labelOption) {
            case NOMIMAL: {
                label = Integer.toString((int)mz);
                break;
            }
            case EXACT: {
                DecimalFormat decimalFormat = this.getDecimalFormatMZ();
                label = decimalFormat.format(mz);
                break;
            }
            case CUSTOM: {
                label = this.customLabels.get(mz);
                if (label != null) break;
                label = "";
                break;
            }
            default: {
                label = "";
            }
        }
        return label;
    }

    private List<BarSeriesIon> getBarSeriesIonList() {
        ISeries[] series;
        ArrayList<BarSeriesIon> barSeriesIons = new ArrayList<BarSeriesIon>();
        int widthPlotArea = this.getBaseChart().getPlotArea().getBounds().width;
        ISeries[] iSeriesArray = series = this.getBaseChart().getSeriesSet().getSeries();
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries barSeries = iSeriesArray[n2];
            if (barSeries != null) {
                double[] xSeries = barSeries.getXSeries();
                double[] ySeries = barSeries.getYSeries();
                int size = barSeries.getXSeries().length;
                int i = 0;
                while (i < size) {
                    Point point = barSeries.getPixelCoordinates(i);
                    if (point.x >= 0 && point.x <= widthPlotArea) {
                        barSeriesIons.add(new BarSeriesIon(xSeries[i], ySeries[i], point));
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return barSeriesIons;
    }

    private DecimalFormat getDecimalFormatMZ() {
        IAxisSettings axisSettings = this.getBaseChart().getXAxisSettings(0);
        if (axisSettings != null) {
            return axisSettings.getDecimalFormat();
        }
        return DEFAULT_DECIMAL_FORMAT;
    }

    private ISeriesData getMassSpectrum(IScanMSD massSpectrum) {
        List ions = massSpectrum.getIons();
        int size = ions.size();
        double[] xSeries = new double[size];
        double[] ySeries = new double[size];
        int i = 0;
        while (i < size) {
            IIon ion = (IIon)ions.get(i);
            xSeries[i] = ion.getIon();
            ySeries[i] = ion.getAbundance();
            ++i;
        }
        return new SeriesData(xSeries, ySeries, "Mass Spectrum");
    }

    public static enum LabelOption {
        NOMIMAL,
        EXACT,
        CUSTOM;

    }
}

