/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.model.support.PeakQuantitation;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class PeakQuantitationListLabelProvider
extends AbstractChemClipseLabelProvider {
    public PeakQuantitationListLabelProvider() {
        super("0.0##");
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof PeakQuantitation) {
            PeakQuantitation peakQuantitationEntry = (PeakQuantitation)element;
            switch (columnIndex) {
                case 0: {
                    text = decimalFormat.format((double)peakQuantitationEntry.getRetentionTime() / 60000.0);
                    break;
                }
                case 1: {
                    text = decimalFormat.format(peakQuantitationEntry.getIntegratedArea());
                    break;
                }
                default: {
                    int index = columnIndex - 2;
                    text = index < peakQuantitationEntry.getConcentrations().size() ? decimalFormat.format(peakQuantitationEntry.getConcentrations().get(index)) : "";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/peak.gif", "16x16");
    }
}

