/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.ui.icons.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.chemclipse.rcp.ui.icons.core.EmptyApplicationImageProvider;
import org.eclipse.chemclipse.rcp.ui.icons.core.IApplicationImage;
import org.eclipse.chemclipse.rcp.ui.icons.core.IApplicationImageProvider;
import org.eclipse.chemclipse.rcp.ui.icons.core.IconBundle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class ApplicationImage
implements IApplicationImage,
BundleTrackerCustomizer<IconBundle> {
    private static final String BUNDLE_SEPARATOR = "/";
    private final BundleTracker<IconBundle> bundleTracker;
    private final Map<String, ImageDescriptor> descriptorCache = new ConcurrentHashMap<String, ImageDescriptor>();
    private final Map<String, Image> imageCache = new ConcurrentHashMap<String, Image>();
    private final Map<String, Collection<String>> listCache = new ConcurrentHashMap<String, Collection<String>>();

    public ApplicationImage(BundleContext bundleContext) {
        this.bundleTracker = new BundleTracker(bundleContext, 44, (BundleTrackerCustomizer)this);
    }

    @Override
    public Image getImage(String fileName, String size) {
        return this.imageCache.computeIfAbsent(String.valueOf(size) + BUNDLE_SEPARATOR + fileName, t -> {
            String[] parts = fileName.split(BUNDLE_SEPARATOR, 2);
            if (parts.length < 2) {
                return EmptyApplicationImageProvider.getInstance().getImage(fileName, size);
            }
            return this.getProvider(parts[0]).getImage(parts[1], size);
        });
    }

    @Override
    public ImageDescriptor getImageDescriptor(String fileName, String size) {
        return this.descriptorCache.computeIfAbsent(String.valueOf(size) + BUNDLE_SEPARATOR + fileName, t -> {
            String[] parts = fileName.split(BUNDLE_SEPARATOR, 2);
            if (parts.length < 2) {
                return EmptyApplicationImageProvider.getInstance().getImageDescriptor(fileName, size);
            }
            return this.getProvider(parts[0]).getImageDescriptor(parts[1], size);
        });
    }

    @Override
    public InputStream getImageAsInputStream(String fileName, String size) throws IOException {
        String[] parts = fileName.split(BUNDLE_SEPARATOR, 2);
        if (parts.length < 2) {
            return EmptyApplicationImageProvider.getInstance().getImageAsInputStream(fileName, size);
        }
        return this.getProvider(parts[0]).getImageAsInputStream(parts[1], size);
    }

    public IconBundle addingBundle(Bundle bundle, BundleEvent event) {
        URL entry = bundle.getEntry("icons/");
        if (entry != null) {
            this.clear();
            return new IconBundle(bundle);
        }
        return null;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, IconBundle object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, IconBundle object) {
        this.clear();
        object.dispose();
    }

    private void clear() {
        this.listCache.clear();
        this.descriptorCache.clear();
        this.imageCache.clear();
    }

    @Override
    public Collection<String> listImages(String size) {
        return this.listCache.computeIfAbsent(size, this::listAllImages);
    }

    private Collection<String> listAllImages(String size) {
        ArrayList<String> images = new ArrayList<String>();
        Map tracked = this.bundleTracker.getTracked();
        for (Map.Entry entry : tracked.entrySet()) {
            Collection<String> listImages = ((IconBundle)entry.getValue()).listImages(size);
            listImages.forEach(bundleKey -> {
                boolean bl = images.add(String.valueOf(((Bundle)entry.getKey()).getSymbolicName()) + BUNDLE_SEPARATOR + bundleKey);
            });
        }
        return images;
    }

    private IApplicationImageProvider getProvider(String bundleName) {
        Map tracked = this.bundleTracker.getTracked();
        for (Map.Entry entry : tracked.entrySet()) {
            if (!((Bundle)entry.getKey()).getSymbolicName().equals(bundleName)) continue;
            return (IApplicationImageProvider)entry.getValue();
        }
        return EmptyApplicationImageProvider.getInstance();
    }

    public void start() {
        this.bundleTracker.open();
    }

    public void stop() {
        this.bundleTracker.close();
    }
}

