/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.chemclipse.msd.swt.ui.internal.editingsupport.LibraryTextEditingSupport;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.MassSpectrumListContentProvider;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.MassSpectrumListContentProviderLazy;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.MassSpectrumListFilter;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.MassSpectrumListLabelProvider;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.MassSpectrumListTableComparator;
import org.eclipse.chemclipse.msd.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MassSpectrumListUI
extends ExtendedTableViewer {
    private static final Logger logger = Logger.getLogger(MassSpectrumListUI.class);
    public static final String NAME = "Name";
    public static final String RETENTION_TIME = "Retention Time";
    public static final String RELATIVE_RETENTION_TIME = "Relative Retention Time";
    public static final String RETENTION_INDEX = "Retention Index";
    public static final String BASE_PEAK = "Base Peak";
    public static final String BASE_PEAK_ABUNDANCE = "Base Peak Abundance";
    public static final String NUMBER_OF_IONS = "Number of Ions";
    public static final String CAS = "CAS";
    public static final String MW = "MW";
    public static final String FORMULA = "Formula";
    public static final String SMILES = "SMILES";
    public static final String INCHI = "InChI";
    public static final String REFERENCE_IDENTIFIER = "Reference Identifier";
    public static final String COMMENTS = "Comments";
    private String[] titles = new String[]{"Name", "Retention Time", "Relative Retention Time", "Retention Index", "Base Peak", "Base Peak Abundance", "Number of Ions", "CAS", "MW", "Formula", "SMILES", "InChI", "Reference Identifier", "Comments"};
    private int[] bounds = new int[]{300, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100};
    private ITableLabelProvider labelProvider;
    private IStructuredContentProvider normalContentProvider;
    private ILazyContentProvider lazyContentProvider;
    private MassSpectrumListFilter massSpectrumListFilter;
    private ViewerComparator tableComparator;
    private IMassSpectra massSpectra;

    public MassSpectrumListUI(Composite parent) {
        this(parent, 268436226);
    }

    public MassSpectrumListUI(Composite parent, int style) {
        super(parent, style);
        this.createColumns();
    }

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.massSpectrumListFilter.setSearchText(searchText, caseSensitive);
        if (this.isVirtualTable() && this.isMassiveData(this.massSpectra) && this.massSpectra != null) {
            if ("".equals(searchText)) {
                this.setInput(this.massSpectra);
            } else {
                try {
                    Shell shell = Display.getDefault().getActiveShell();
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
                    DatabaseSearchRunnable databaseSearchRunnable = new DatabaseSearchRunnable();
                    dialog.run(true, false, (IRunnableWithProgress)databaseSearchRunnable);
                    this.updateInput(databaseSearchRunnable.getFilteredMassSpectra());
                }
                catch (InvocationTargetException e) {
                    logger.warn((Object)e);
                    this.setInput(this.massSpectra);
                }
                catch (InterruptedException e) {
                    logger.warn((Object)e);
                    this.setInput(this.massSpectra);
                }
            }
        }
        this.refresh();
    }

    public void setInput(IMassSpectra massSpectra) {
        this.massSpectra = massSpectra;
        this.updateInput(massSpectra);
    }

    private void updateInput(IMassSpectra massSpectra) {
        if (massSpectra != null) {
            int size = massSpectra.size();
            boolean massiveData = this.isMassiveData(massSpectra);
            super.setInput(null);
            this.setLabelAndContentProviders(massiveData);
            super.setInput((Object)massSpectra);
            this.setItemCount(size);
        }
    }

    private void createColumns() {
        this.createColumns(this.titles, this.bounds);
        this.labelProvider = new MassSpectrumListLabelProvider();
        this.normalContentProvider = new MassSpectrumListContentProvider();
        this.lazyContentProvider = new MassSpectrumListContentProviderLazy((TableViewer)this);
        this.tableComparator = new MassSpectrumListTableComparator();
        this.setLabelAndContentProviders(this.isVirtualTable());
        this.massSpectrumListFilter = new MassSpectrumListFilter();
        this.setFilters(new ViewerFilter[]{this.massSpectrumListFilter});
        this.setEditingSupport();
    }

    private void setLabelAndContentProviders(boolean massiveData) {
        this.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        if (massiveData && this.isVirtualTable()) {
            logger.info((Object)"Lazy (Virtual) Modus");
            this.setContentProvider((IContentProvider)this.lazyContentProvider);
            this.setUseHashlookup(true);
            this.setComparator(null);
        } else {
            logger.info((Object)"Normal Modus");
            this.setContentProvider((IContentProvider)this.normalContentProvider);
            this.setUseHashlookup(false);
            this.setComparator(this.tableComparator);
        }
    }

    private void setEditingSupport() {
        HashSet<String> excludeFromEditing = new HashSet<String>();
        excludeFromEditing.add(BASE_PEAK);
        excludeFromEditing.add(BASE_PEAK_ABUNDANCE);
        excludeFromEditing.add(NUMBER_OF_IONS);
        List tableViewerColumns = this.getTableViewerColumns();
        for (TableViewerColumn tableViewerColumn : tableViewerColumns) {
            String columnLabel = tableViewerColumn.getColumn().getText();
            if (excludeFromEditing.contains(columnLabel)) continue;
            tableViewerColumn.setEditingSupport((EditingSupport)new LibraryTextEditingSupport(this, columnLabel));
        }
    }

    private boolean isMassiveData(IMassSpectra massSpectra) {
        if (massSpectra != null) {
            int limitMassiveData = PreferenceSupplier.getLibraryMSDLimitSorting();
            return massSpectra.size() > limitMassiveData;
        }
        return false;
    }

    private boolean isVirtualTable() {
        return (this.getTable().getStyle() & 0x10000000) == 0x10000000;
    }

    private class DatabaseSearchRunnable
    implements IRunnableWithProgress {
        private IMassSpectra filteredMassSpectra = new MassSpectra();

        private DatabaseSearchRunnable() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                monitor.beginTask("Search DB", -1);
                this.filteredMassSpectra = new MassSpectra();
                for (IScanMSD scanMSD : MassSpectrumListUI.this.massSpectra.getList()) {
                    if (MassSpectrumListUI.this.massSpectrumListFilter.matchElement(scanMSD)) {
                        this.filteredMassSpectra.addMassSpectrum(scanMSD);
                    }
                    if (!monitor.isCanceled()) continue;
                    break;
                }
            }
            finally {
                monitor.done();
            }
        }

        public IMassSpectra getFilteredMassSpectra() {
            return this.filteredMassSpectra;
        }
    }
}

