/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core;

import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IPeakIon;
import org.eclipse.chemclipse.msd.model.core.PeakIonType;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;

public abstract class AbstractPeakIon
extends AbstractIon
implements IPeakIon {
    private static final long serialVersionUID = -3520745862587712333L;
    private float uncertaintyFactor = 1.0f;
    private PeakIonType peakIonType = PeakIonType.NO_TYPE;

    public AbstractPeakIon(double ion) throws IonLimitExceededException {
        super(ion);
    }

    public AbstractPeakIon(double ion, float abundance) throws AbundanceLimitExceededException, IonLimitExceededException {
        super(ion, abundance);
    }

    public AbstractPeakIon(IIon ion) throws AbundanceLimitExceededException, IonLimitExceededException {
        super(ion.getIon(), ion.getAbundance());
    }

    public AbstractPeakIon(double ion, float abundance, float uncertaintyFactor) throws AbundanceLimitExceededException, IonLimitExceededException {
        super(ion, abundance);
        this.setUncertaintyFactor(uncertaintyFactor);
    }

    @Override
    public float getUncertaintyFactor() {
        return this.uncertaintyFactor;
    }

    @Override
    public void setUncertaintyFactor(float uncertaintyFactor) {
        if (uncertaintyFactor >= 0.0f && uncertaintyFactor <= 1.0f) {
            this.uncertaintyFactor = uncertaintyFactor;
        }
    }

    @Override
    public PeakIonType getPeakIonType() {
        return this.peakIonType;
    }

    @Override
    public void setPeakIonType(PeakIonType peakIonType) {
        if (peakIonType != null) {
            this.peakIonType = peakIonType;
        }
    }
}

