/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.classifier.supplier.molpeak.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.msd.classifier.supplier.molpeak.Activator;
import org.eclipse.chemclipse.msd.classifier.supplier.molpeak.settings.ClassifierSettings;
import org.eclipse.chemclipse.msd.classifier.supplier.molpeak.settings.IBasePeakSettings;
import org.eclipse.chemclipse.msd.classifier.supplier.molpeak.settings.MassSpectrumIdentifierSettings;
import org.eclipse.chemclipse.msd.classifier.supplier.molpeak.settings.PeakIdentifierSettings;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceSupplier
implements IPreferenceSupplier {
    public static final String P_MATCH_SENSITIVITY = "matchSensitivity";
    public static final float DEF_MATCH_SENSITIVITY = 80.0f;
    public static final float MIN_MATCH_SENSITIVITY = 0.0f;
    public static final float MAX_MATCH_SENSITIVITY = 100.0f;
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_MATCH_SENSITIVITY, Float.toString(80.0f));
        return defaultValues;
    }

    public static MassSpectrumIdentifierSettings getMassSpectrumIdentifierSettings() {
        MassSpectrumIdentifierSettings settings = new MassSpectrumIdentifierSettings();
        PreferenceSupplier.setBasePeakSettings(settings);
        return settings;
    }

    public static PeakIdentifierSettings getPeakIdentifierSettings() {
        PeakIdentifierSettings settings = new PeakIdentifierSettings();
        PreferenceSupplier.setBasePeakSettings(settings);
        return settings;
    }

    public static ClassifierSettings getChromatogramClassifierSettings() {
        return new ClassifierSettings();
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    private static void setBasePeakSettings(IBasePeakSettings settings) {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        settings.setMatchSensitivity(preferences.getFloat(P_MATCH_SENSITIVITY, 80.0f));
    }
}

