/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.wizard.samplequant;

import java.io.File;
import java.util.Date;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.core.SampleQuantProcessor;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.ISampleQuantReport;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.Activator;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.wizard.samplequant.ISampleQuantWizardElements;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.wizard.samplequant.PageDataVerification;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.wizard.samplequant.PageReportDataSelection;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.wizard.samplequant.SampleQuantWizardElements;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.support.ui.wizards.AbstractFileWizard;
import org.eclipse.chemclipse.support.ui.wizards.ChromatogramWizardElements;
import org.eclipse.chemclipse.support.ui.wizards.IChromatogramWizardElements;
import org.eclipse.chemclipse.ux.extension.xxd.ui.wizards.InputEntriesWizardPage;
import org.eclipse.chemclipse.ux.extension.xxd.ui.wizards.InputWizardSettings;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;

public class WizardSampleQuant
extends AbstractFileWizard {
    public static final int PREFERRED_WIDTH = 350;
    public static final int PREFERRED_HEIGHT = 500;
    private final ISampleQuantWizardElements wizardElements = new SampleQuantWizardElements();
    private InputEntriesWizardPage pageInputEntries;
    private PageReportDataSelection pageReportDataSelection;
    private PageDataVerification pageDataVerification;

    public WizardSampleQuant() {
        super("SampleQuantReport_" + new Date().getTime(), ".sqr");
    }

    public void addPages() {
        super.addPages();
        InputWizardSettings inputWizardSettings = InputWizardSettings.create((IPreferenceStore)Activator.getDefault().getPreferenceStore(), (String)"samplequantFilterPathChromatogram", (DataType[])new DataType[]{DataType.MSD});
        inputWizardSettings.setTitle("Open Chromatogram (MSD) File(s)");
        inputWizardSettings.setDescription("Select a chromatogram/chromatograms file to open.");
        this.pageInputEntries = new InputEntriesWizardPage(inputWizardSettings);
        this.pageReportDataSelection = new PageReportDataSelection(this.wizardElements);
        this.pageDataVerification = new PageDataVerification(this.wizardElements);
        this.addPage((IWizardPage)this.pageInputEntries);
        this.addPage((IWizardPage)this.pageReportDataSelection);
        this.addPage((IWizardPage)this.pageDataVerification);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (page == this.pageInputEntries) {
            this.wizardElements.clearSelectedChromatograms();
            ChromatogramWizardElements elements = new ChromatogramWizardElements();
            for (File file : this.pageInputEntries.getSelectedItems().keySet()) {
                elements.addSelectedChromatogram(file.getAbsolutePath());
            }
            this.wizardElements.addElements((IChromatogramWizardElements)elements);
            this.pageInputEntries.savePath();
        }
        return nextPage;
    }

    public boolean canFinish() {
        boolean canFinish;
        boolean bl = canFinish = this.wizardElements.getSelectedChromatograms().size() > 0;
        if (canFinish) {
            canFinish = this.wizardElements.isDataVerified();
        }
        return canFinish;
    }

    public void doFinish(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Create Sample Quantitation", -1);
        IFile file = super.prepareProject(monitor);
        ISampleQuantReport sampleQuantReport = this.wizardElements.getSampleQuantReport();
        String chromatogram = (String)this.wizardElements.getSelectedChromatograms().get(0);
        File sampleQuantReportFile = file.getLocation().toFile();
        SampleQuantProcessor sampleQuantProcessor = new SampleQuantProcessor();
        sampleQuantProcessor.createSampleQuantReport(sampleQuantReportFile, sampleQuantReport, chromatogram, monitor);
        super.refreshWorkspace(monitor);
        super.runOpenEditor(file, monitor);
    }
}

