/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters.RetentionTime2Filter;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards.IFilterWizardPage;
import org.eclipse.chemclipse.model.statistics.IVariable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class FilterRetentionTime2WizardPage
extends WizardPage
implements IFilterWizardPage {
    private RetentionTime2Filter retentionTimeFilter;
    private TableViewer tableViewer;
    private List<IVariable> variables;

    public FilterRetentionTime2WizardPage(RetentionTime2Filter retentionTimeFilter) {
        super("Retention time filter");
        this.setTitle("Retention Time Filter");
        this.variables = new ArrayList<IVariable>(retentionTimeFilter.getVariables());
        this.retentionTimeFilter = retentionTimeFilter;
    }

    private void createColumns() {
        String[] titles = new String[]{"Value", "Description"};
        int[] bounds = new int[]{150, 150};
        TableViewerColumn col = this.createTableViewerColumn(titles[0], bounds[0]);
        col.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IVariable value = (IVariable)cell.getElement();
                cell.setText(value.getValue());
            }
        });
        col = this.createTableViewerColumn(titles[1], bounds[1]);
        col.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IVariable retentionTime = (IVariable)cell.getElement();
                String description = retentionTime.getDescription();
                if (description != null) {
                    cell.setText(retentionTime.getDescription());
                } else {
                    cell.setText("");
                }
            }
        });
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Table table = new Table(composite, 65538);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.createColumns();
        this.tableViewer.setInput(this.variables);
        Button button = new Button(composite, 8);
        button.setText("Remove Selected Retention Times");
        button.addListener(13, e -> this.remove());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)button);
        this.setControl((Control)composite);
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            this.variables.remove(it.next());
        }
        this.updateTable();
    }

    @Override
    public void update() {
        List variables = this.retentionTimeFilter.getVariables();
        variables.clear();
        variables.addAll(this.variables);
    }

    private void updateTable() {
        this.tableViewer.refresh();
        TableColumn[] tableColumnArray = this.tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
    }
}

