/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.provider;

import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class SamplesEditingSupport
extends EditingSupport {
    private CellEditor cellEditor;
    private final ExtendedTableViewer tableViewer;
    private final String column;

    public SamplesEditingSupport(ExtendedTableViewer tableViewer, String column) {
        super((ColumnViewer)tableViewer);
        this.column = column;
        this.cellEditor = "Use".equals(column) ? new CheckboxCellEditor((Composite)tableViewer.getTable()) : new TextCellEditor((Composite)tableViewer.getTable());
        this.tableViewer = tableViewer;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        block11: {
            if (!(element instanceof ISample)) break block11;
            ISample sample = (ISample)element;
            switch (this.column) {
                case "Use": {
                    return sample.isSelected();
                }
                case "Group Name": {
                    String groupName = sample.getGroupName();
                    if (groupName == null) {
                        return "";
                    }
                    return groupName;
                }
            }
        }
        return false;
    }

    protected void setValue(Object element, Object value) {
        block11: {
            if (!(element instanceof ISample)) break block11;
            ISample sample = (ISample)element;
            switch (this.column) {
                case "Use": {
                    sample.setSelected(((Boolean)value).booleanValue());
                    break;
                }
                case "Group Name": {
                    String groupName = (String)value;
                    if ("".equals(groupName)) {
                        sample.setGroupName(null);
                        break;
                    }
                    sample.setGroupName(groupName);
                }
            }
            this.tableViewer.refresh(element);
        }
    }
}

