/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.chart2d;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.EvaluationPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IResultPCA;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IResultsPCA;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.extensions.barcharts.BarChart;
import org.eclipse.swtchart.extensions.barcharts.BarSeriesData;
import org.eclipse.swtchart.extensions.barcharts.IBarSeriesSettings;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.IPrimaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.RangeRestriction;
import org.eclipse.swtchart.extensions.core.SeriesData;

public class ErrorResidueChart
extends BarChart {
    public ErrorResidueChart() {
        this.initialize();
    }

    public ErrorResidueChart(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void setInput(EvaluationPCA evaluationPCA) {
        if (evaluationPCA != null) {
            IResultsPCA resultsPCA = evaluationPCA.getResults();
            this.updateChart(resultsPCA);
        } else {
            this.updateChart(null);
        }
    }

    private void initialize() {
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.setTitle("Error Residues");
        chartSettings.setTitleVisible(true);
        chartSettings.setTitleColor(Colors.BLACK);
        chartSettings.setOrientation(256);
        chartSettings.setHorizontalSliderVisible(false);
        chartSettings.setVerticalSliderVisible(false);
        RangeRestriction rangeRestriction = chartSettings.getRangeRestriction();
        rangeRestriction.setZeroX(false);
        rangeRestriction.setZeroY(false);
        rangeRestriction.setForceZeroMinY(true);
        rangeRestriction.setRestrictZoom(true);
        chartSettings.setShowAxisZeroMarker(true);
        chartSettings.setColorAxisZeroMarker(Colors.BLACK);
        chartSettings.setShowSeriesLabelMarker(false);
        chartSettings.setCreateMenu(true);
        chartSettings.setEnableCompress(false);
        this.setPrimaryAxisSet(chartSettings);
        this.applySettings(chartSettings);
    }

    private void setPrimaryAxisSet(IChartSettings chartSettings) {
        IPrimaryAxisSettings primaryAxisSettingsX = chartSettings.getPrimaryAxisSettingsX();
        primaryAxisSettingsX.setTitle("Sample Name");
        primaryAxisSettingsX.setDecimalFormat(ValueFormat.getDecimalFormatEnglish());
        primaryAxisSettingsX.setColor(Colors.BLACK);
        IPrimaryAxisSettings primaryAxisSettingsY = chartSettings.getPrimaryAxisSettingsY();
        primaryAxisSettingsY.setTitle("Error Values");
        primaryAxisSettingsY.setDecimalFormat(ValueFormat.getDecimalFormatEnglish());
        primaryAxisSettingsY.setColor(Colors.BLACK);
    }

    private void updateChart(IResultsPCA pcaResults) {
        this.deleteSeries();
        if (pcaResults != null) {
            IChartSettings chartSettings = this.getChartSettings();
            IPrimaryAxisSettings primaryAxisSettingsX = chartSettings.getPrimaryAxisSettingsX();
            primaryAxisSettingsX.setEnableCategory(true);
            primaryAxisSettingsX.setCategorySeries(this.getCategories(pcaResults));
            this.applySettings(chartSettings);
            ArrayList<BarSeriesData> barSeriesDataList = new ArrayList<BarSeriesData>();
            ISeriesData seriesData = this.getSeries(pcaResults);
            BarSeriesData barSeriesData = new BarSeriesData(seriesData);
            IBarSeriesSettings settings = barSeriesData.getSettings();
            settings.setBarColor(Colors.RED);
            settings.setBarWidthStyle(IBarSeries.BarWidthStyle.STRETCHED);
            barSeriesDataList.add(barSeriesData);
            this.addSeriesData(barSeriesDataList);
        } else {
            this.getBaseChart().redraw();
        }
    }

    private String[] getCategories(IResultsPCA pcaResults) {
        List pcaResultList = pcaResults.getPcaResultList();
        int size = pcaResultList.size();
        String[] categories = new String[size];
        int i = 0;
        while (i < size) {
            IResultPCA pcaResult = (IResultPCA)pcaResultList.get(i);
            categories[i] = pcaResult.getSample().getName();
            ++i;
        }
        return categories;
    }

    private ISeriesData getSeries(IResultsPCA pcaResults) {
        List pcaResultList = pcaResults.getPcaResultList();
        int size = pcaResultList.size();
        double[] xSeries = new double[size];
        double[] ySeries = new double[size];
        int i = 0;
        while (i < size) {
            IResultPCA pcaResult = (IResultPCA)pcaResultList.get(i);
            xSeries[i] = i;
            ySeries[i] = pcaResult.getErrorMemberShip();
            ++i;
        }
        SeriesData seriesData = new SeriesData(xSeries, ySeries, "Error Residues");
        return seriesData;
    }
}

