/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.ui.swt;

import java.text.DecimalFormat;
import java.util.List;
import org.eclipse.chemclipse.msd.model.core.ICombinedMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassValueDisplayPrecision;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.SimpleMassSpectrumUI;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NoiseMassSpectraUI
extends Composite {
    private SimpleMassSpectrumUI noiseMassSpectrumUI;
    private List<ICombinedMassSpectrum> massSpectra;
    private ICombinedMassSpectrum actualMassSpectrum;
    private int index = 0;
    private Button buttonPrevious;
    private Button buttonNext;
    private Text textGoto;
    private Button buttonGoto;
    private Label labelDetails;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    public NoiseMassSpectraUI(Composite parent, int style) {
        super(parent, style);
        this.initialize(parent);
    }

    public void update(List<ICombinedMassSpectrum> massSpectra, boolean forceReload) {
        this.massSpectra = massSpectra;
        this.index = 0;
        this.setMassSpectrum(this.index);
    }

    private void initialize(Composite parent) {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 4);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        Composite buttonbar = new Composite(composite, 4);
        buttonbar.setLayout((Layout)new FillLayout());
        this.buttonPrevious = new Button(buttonbar, 0);
        this.buttonPrevious.setText("Previous");
        this.buttonPrevious.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NoiseMassSpectraUI.this.setPreviousMassSpectrum();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.buttonNext = new Button(buttonbar, 0);
        this.buttonNext.setText("Next");
        this.buttonNext.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NoiseMassSpectraUI.this.setNextMassSpectrum();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.textGoto = new Text(buttonbar, 2048);
        this.textGoto.setText("1");
        this.textGoto.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 | e.keyCode == 0x1000050) {
                    NoiseMassSpectraUI.this.setSelectedMassSpectrum(NoiseMassSpectraUI.this.textGoto.getText());
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.buttonGoto = new Button(buttonbar, 0);
        this.buttonGoto.setText("Select");
        this.buttonGoto.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NoiseMassSpectraUI.this.setSelectedMassSpectrum(NoiseMassSpectraUI.this.textGoto.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.labelDetails = new Label(composite, 0);
        this.labelDetails.setText("(0) 0 | Scan Range: | RT: ");
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.labelDetails.setLayoutData((Object)gridData);
        this.noiseMassSpectrumUI = new SimpleMassSpectrumUI(composite, 2052, MassValueDisplayPrecision.NOMINAL);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.noiseMassSpectrumUI.setLayoutData(gridData);
    }

    private final void setPreviousMassSpectrum() {
        --this.index;
        int min = 0;
        if (this.index < min) {
            this.index = min;
        }
        this.setMassSpectrum(this.index);
    }

    private final void setNextMassSpectrum() {
        ++this.index;
        int max = this.massSpectra.size() - 1;
        if (this.index > max) {
            this.index = max;
        }
        this.setMassSpectrum(this.index);
    }

    private final void setSelectedMassSpectrum(String number) {
        try {
            int selection;
            this.index = selection = Integer.parseInt(number) - 1;
            int min = 0;
            int max = this.massSpectra.size() - 1;
            if (this.index > max) {
                this.index = max;
            }
            if (this.index < min) {
                this.index = min;
            }
            this.setMassSpectrum(this.index);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void setMassSpectrum(int index) {
        int min = 0;
        int max = this.massSpectra.size() - 1;
        if (index == min) {
            this.buttonPrevious.setEnabled(false);
            this.buttonNext.setEnabled(true);
        } else if (index == max) {
            this.buttonPrevious.setEnabled(true);
            this.buttonNext.setEnabled(false);
        } else {
            this.buttonPrevious.setEnabled(true);
            this.buttonNext.setEnabled(true);
        }
        ICombinedMassSpectrum massSpectrum = this.massSpectra.get(index);
        if (massSpectrum != null) {
            this.actualMassSpectrum = massSpectrum;
            this.setDetailsLabel();
            this.noiseMassSpectrumUI.update((IScanMSD)massSpectrum, true);
        }
    }

    private void setDetailsLabel() {
        int number = this.index + 1;
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(number);
        builder.append(") ");
        builder.append(this.massSpectra.size());
        builder.append(" | ");
        builder.append("Scan Range: ");
        builder.append(this.actualMassSpectrum.getStartScan());
        builder.append(" - ");
        builder.append(this.actualMassSpectrum.getStopScan());
        builder.append(" | ");
        builder.append("RT: ");
        builder.append(this.decimalFormat.format((double)this.actualMassSpectrum.getStartRetentionTime() / 60000.0));
        builder.append(" - ");
        builder.append(this.decimalFormat.format((double)this.actualMassSpectrum.getStopRetentionTime() / 60000.0));
        this.labelDetails.setText(builder.toString());
    }
}

