/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.comparator;

import java.util.Comparator;
import org.eclipse.chemclipse.model.comparator.SortOrder;
import org.eclipse.chemclipse.model.core.IPeak;

public class ChromatogramPeakComparator
implements Comparator<IPeak> {
    private SortOrder sortOrder;

    public ChromatogramPeakComparator() {
        this.sortOrder = SortOrder.ASC;
    }

    public ChromatogramPeakComparator(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    @Override
    public int compare(IPeak peak1, IPeak peak2) {
        int returnValue;
        int retentionTime1 = peak1.getPeakModel().getRetentionTimeAtPeakMaximum();
        int retentionTime2 = peak2.getPeakModel().getRetentionTimeAtPeakMaximum();
        switch (this.sortOrder) {
            case ASC: {
                returnValue = Integer.compare(retentionTime1, retentionTime2);
                break;
            }
            case DESC: {
                returnValue = Integer.compare(retentionTime2, retentionTime1);
                break;
            }
            default: {
                returnValue = Integer.compare(retentionTime1, retentionTime2);
            }
        }
        return returnValue;
    }
}

