/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.IQuantDatabase;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.controller.ConcentrationResponseEntryEdit;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.provider.ConcentrationResponseContentProvider;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.provider.ConcentrationResponseLabelProvider;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.provider.ConcentrationResponseTableComparator;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.runnables.dialogs.ConcentrationResponseEntryEditDialog;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.swt.AbstractTableViewerUI;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.swt.IQuantitationCompoundUpdater;
import org.eclipse.chemclipse.msd.model.core.quantitation.IConcentrationResponseEntriesMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IConcentrationResponseEntryMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationCompoundMSD;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ConcentrationResponseEntriesUI
extends AbstractTableViewerUI
implements IQuantitationCompoundUpdater {
    private static final String MESSAGE_BOX_TEXT = "Concentration Response Entry";
    private IQuantitationCompoundMSD quantitationCompoundMSD;
    private IEventBroker eventBroker;
    private IQuantDatabase database;
    private Map<String, Object> map;

    public ConcentrationResponseEntriesUI(Composite parent, int style, IEventBroker eventBroker) {
        parent.setLayout((Layout)new FillLayout());
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.addList(composite);
        this.addButtons(composite);
        this.eventBroker = eventBroker;
        this.map = new HashMap<String, Object>();
    }

    @Override
    public void update(IQuantitationCompoundMSD quantitationCompoundMSD, IQuantDatabase database) {
        this.database = database;
        this.quantitationCompoundMSD = quantitationCompoundMSD;
        if (quantitationCompoundMSD == null || database == null) {
            this.getTableViewer().setInput(null);
        } else {
            this.setTableViewerInput();
        }
    }

    private void setTableViewerInput() {
        this.getTableViewer().setInput((Object)this.quantitationCompoundMSD);
    }

    private void addList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridDataTable = new GridData(1808);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)gridDataTable);
        String[] titles = new String[]{"Ion (0 = TIC)", "Concentration", "Response"};
        int[] bounds = new int[]{100, 100, 100};
        ConcentrationResponseContentProvider contentProvider = new ConcentrationResponseContentProvider();
        ConcentrationResponseLabelProvider labelProvider = new ConcentrationResponseLabelProvider();
        ConcentrationResponseTableComparator viewerTableComparator = new ConcentrationResponseTableComparator();
        this.createTableViewer(composite, gridDataTable, contentProvider, (LabelProvider)labelProvider, viewerTableComparator, titles, bounds);
        this.setTableViewerInput();
    }

    private void addButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData gridDataButtons = new GridData(1040);
        gridDataButtons.verticalAlignment = 128;
        composite.setLayoutData((Object)gridDataButtons);
        GridData gridData = new GridData(768);
        this.addButtonAdd(composite, gridData);
        this.addButtonEdit(composite, gridData);
        this.addButtonRemove(composite, gridData);
        this.addButtonRemoveAll(composite, gridData);
    }

    private void addButtonAdd(Composite parent, GridData gridData) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)gridData);
        button.setText("Add");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConcentrationResponseEntriesUI.this.quantitationCompoundMSD != null) {
                    IConcentrationResponseEntryMSD concentrationResponseEntryMSD;
                    String concentrationUnit;
                    ConcentrationResponseEntryEdit concentrationResponseEntryEdit;
                    Shell shell = Display.getCurrent().getActiveShell();
                    ConcentrationResponseEntryEditDialog dialog = new ConcentrationResponseEntryEditDialog(shell, concentrationResponseEntryEdit = new ConcentrationResponseEntryEdit(concentrationUnit = ConcentrationResponseEntriesUI.this.quantitationCompoundMSD.getConcentrationUnit()), "Create a new concentration response entry.");
                    if (dialog.open() == 0 && (concentrationResponseEntryMSD = concentrationResponseEntryEdit.getConcentrationResponseEntryMSD()) != null) {
                        ConcentrationResponseEntriesUI.this.quantitationCompoundMSD.getConcentrationResponseEntriesMSD().add(concentrationResponseEntryMSD);
                        ConcentrationResponseEntriesUI.this.setTableViewerInput();
                        ConcentrationResponseEntriesUI.this.triggerCompoundDocumentUpdateEvent();
                    }
                } else {
                    ConcentrationResponseEntriesUI.this.showMessage(ConcentrationResponseEntriesUI.MESSAGE_BOX_TEXT, "Please select a quantitation compound previously.");
                }
            }
        });
    }

    private void addButtonEdit(Composite parent, GridData gridData) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)gridData);
        button.setText("Edit");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConcentrationResponseEntriesUI.this.quantitationCompoundMSD != null) {
                    IConcentrationResponseEntryMSD concentrationResponseEntryOld = ConcentrationResponseEntriesUI.this.getSelectedConcentrationResponseEntryMSD();
                    if (concentrationResponseEntryOld != null) {
                        Shell shell = Display.getCurrent().getActiveShell();
                        String concentrationUnit = ConcentrationResponseEntriesUI.this.quantitationCompoundMSD.getConcentrationUnit();
                        ConcentrationResponseEntryEdit concentrationResponseEntryEdit = new ConcentrationResponseEntryEdit(concentrationUnit);
                        concentrationResponseEntryEdit.setConcentrationResponseEntryMSD(concentrationResponseEntryOld);
                        ConcentrationResponseEntryEditDialog dialog = new ConcentrationResponseEntryEditDialog(shell, concentrationResponseEntryEdit, "Edit the concentration response entry.");
                        if (dialog.open() == 0) {
                            IConcentrationResponseEntryMSD concentrationResponseEntryNew = concentrationResponseEntryEdit.getConcentrationResponseEntryMSD();
                            if (concentrationResponseEntryOld != null) {
                                IConcentrationResponseEntriesMSD concentrationResponseEntriesMSD = ConcentrationResponseEntriesUI.this.quantitationCompoundMSD.getConcentrationResponseEntriesMSD();
                                concentrationResponseEntriesMSD.remove(concentrationResponseEntryOld);
                                concentrationResponseEntriesMSD.add(concentrationResponseEntryNew);
                                ConcentrationResponseEntriesUI.this.quantitationCompoundMSD.updateConcentrationResponseEntries(concentrationResponseEntriesMSD);
                                ConcentrationResponseEntriesUI.this.setTableViewerInput();
                                ConcentrationResponseEntriesUI.this.triggerCompoundDocumentUpdateEvent();
                            }
                        }
                    } else {
                        ConcentrationResponseEntriesUI.this.showMessage(ConcentrationResponseEntriesUI.MESSAGE_BOX_TEXT, "Please select a concentration response entry.");
                    }
                } else {
                    ConcentrationResponseEntriesUI.this.showMessage(ConcentrationResponseEntriesUI.MESSAGE_BOX_TEXT, "Please select a quantitation compound previously.");
                }
            }
        });
    }

    private void addButtonRemove(Composite parent, GridData gridData) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)gridData);
        button.setText("Delete");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List concentrationResponseEntriesMSD = ConcentrationResponseEntriesUI.this.getSelectedConcentrationResponseEntriesMSD();
                if (concentrationResponseEntriesMSD.size() > 0) {
                    int decision = ConcentrationResponseEntriesUI.this.showQuestion(ConcentrationResponseEntriesUI.MESSAGE_BOX_TEXT, "Would you like to delete the selected concentration response entries?");
                    if (decision == 64) {
                        ConcentrationResponseEntriesUI.this.quantitationCompoundMSD.getConcentrationResponseEntriesMSD().removeAll(concentrationResponseEntriesMSD);
                        ConcentrationResponseEntriesUI.this.setTableViewerInput();
                        ConcentrationResponseEntriesUI.this.triggerCompoundDocumentUpdateEvent();
                    }
                } else {
                    ConcentrationResponseEntriesUI.this.showMessage(ConcentrationResponseEntriesUI.MESSAGE_BOX_TEXT, "Please select concentration response entries to delete.");
                }
            }
        });
    }

    private void addButtonRemoveAll(Composite parent, GridData gridData) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)gridData);
        button.setText("Delete All");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int decision = ConcentrationResponseEntriesUI.this.showQuestion(ConcentrationResponseEntriesUI.MESSAGE_BOX_TEXT, "Would you like to delete all response entry?");
                if (decision == 64) {
                    ConcentrationResponseEntriesUI.this.quantitationCompoundMSD.getConcentrationResponseEntriesMSD().clear();
                    ConcentrationResponseEntriesUI.this.setTableViewerInput();
                    ConcentrationResponseEntriesUI.this.triggerCompoundDocumentUpdateEvent();
                }
            }
        });
    }

    private void triggerCompoundDocumentUpdateEvent() {
        if (this.eventBroker != null && this.quantitationCompoundMSD != null && this.database != null) {
            this.map.clear();
            this.map.put("QuantitationCompoundDocument", this.quantitationCompoundMSD);
            this.map.put("Database", this.database);
            this.eventBroker.send("quantitation/msd/update/supplier/chemclipse/quantitationcompounddocument", this.map);
        }
    }

    private IConcentrationResponseEntryMSD getSelectedConcentrationResponseEntryMSD() {
        IConcentrationResponseEntryMSD concentrationResponseEntryMSD = null;
        Object element = this.getSelectedTableItem();
        if (element instanceof IConcentrationResponseEntryMSD) {
            concentrationResponseEntryMSD = (IConcentrationResponseEntryMSD)element;
        }
        return concentrationResponseEntryMSD;
    }

    private List<IConcentrationResponseEntryMSD> getSelectedConcentrationResponseEntriesMSD() {
        ArrayList<IConcentrationResponseEntryMSD> concentrationResponseEntriesMSD = new ArrayList<IConcentrationResponseEntryMSD>();
        List<Object> elements = this.getSelectedTableItems();
        for (Object element : elements) {
            if (!(element instanceof IConcentrationResponseEntryMSD)) continue;
            IConcentrationResponseEntryMSD concentrationResponseEntryMSD = (IConcentrationResponseEntryMSD)element;
            concentrationResponseEntriesMSD.add(concentrationResponseEntryMSD);
        }
        return concentrationResponseEntriesMSD;
    }
}

