/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.wizards;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.IQuantDatabase;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectDocumentPage
extends WizardPage {
    private List<String> peakTargetNames;
    private IQuantDatabase database;
    protected Button buttonMerge;
    protected Combo comboQuantitationCompoundNames;
    protected Text textConcentrationMerge;
    private Label labelConcentrationUnitMerge;
    protected Button buttonCreate;
    protected Combo comboPeakTargetNames;
    protected Text textConcentrationCreate;
    protected Text textConcentrationUnitCreate;
    protected Text textChemicalClassCreate;
    private Label label1;
    private Label label2;
    private Label label3;

    protected SelectDocumentPage(String pageName, List<String> peakTargetNames, IQuantDatabase database) {
        super(pageName);
        this.setTitle("Quantitation Support");
        this.setDescription("Create a quantitation document.");
        this.peakTargetNames = peakTargetNames;
        this.database = database;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.createMergePeakControls(composite, gridData);
        this.createAddPeakControls(composite, gridData);
        this.enableMergePeakControls(true);
        this.setControl((Control)composite);
    }

    private void createMergePeakControls(Composite parent, GridData gridData) {
        GridData gridDataFill = new GridData(768);
        gridDataFill.grabExcessHorizontalSpace = true;
        this.buttonMerge = new Button(parent, 16);
        this.buttonMerge.setText("Add peak to existing component");
        this.buttonMerge.setSelection(true);
        this.buttonMerge.setLayoutData((Object)gridData);
        this.buttonMerge.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectDocumentPage.this.enableMergePeakControls(SelectDocumentPage.this.buttonMerge.getSelection());
            }
        });
        this.comboQuantitationCompoundNames = new Combo(parent, 0);
        if (this.database != null) {
            List quantitationCompoundNames = this.database.getQuantitationCompoundNames();
            this.comboQuantitationCompoundNames.setItems(quantitationCompoundNames.toArray(new String[quantitationCompoundNames.size()]));
        }
        this.comboQuantitationCompoundNames.setLayoutData((Object)gridData);
        this.comboQuantitationCompoundNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SelectDocumentPage.this.database != null) {
                    String name = SelectDocumentPage.this.comboQuantitationCompoundNames.getText();
                    String concentrationUnit = SelectDocumentPage.this.database.getQuantitationCompoundConcentrationUnit(name);
                    SelectDocumentPage.this.labelConcentrationUnitMerge.setText(concentrationUnit);
                }
            }
        });
        this.textConcentrationMerge = new Text(parent, 2048);
        this.labelConcentrationUnitMerge = new Label(parent, 0);
        this.labelConcentrationUnitMerge.setText("");
        this.labelConcentrationUnitMerge.setLayoutData((Object)gridDataFill);
    }

    private void createAddPeakControls(Composite parent, GridData gridData) {
        this.buttonCreate = new Button(parent, 16);
        this.buttonCreate.setLayoutData((Object)gridData);
        this.buttonCreate.setText("Create a new component");
        this.buttonCreate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectDocumentPage.this.enableMergePeakControls(SelectDocumentPage.this.buttonMerge.getSelection());
            }
        });
        this.comboPeakTargetNames = new Combo(parent, 0);
        if (this.peakTargetNames.size() > 0) {
            this.comboPeakTargetNames.setItems(this.peakTargetNames.toArray(new String[this.peakTargetNames.size()]));
        }
        this.comboPeakTargetNames.setLayoutData((Object)gridData);
        this.textConcentrationCreate = new Text(parent, 2048);
        this.label1 = new Label(parent, 0);
        this.label1.setText("Concentration");
        this.textConcentrationUnitCreate = new Text(parent, 2048);
        this.label2 = new Label(parent, 0);
        this.label2.setText("Concentration Unit (e.g. mg/ml)");
        this.textChemicalClassCreate = new Text(parent, 2048);
        this.label3 = new Label(parent, 0);
        this.label3.setText("Chemical Class");
    }

    private void enableMergePeakControls(boolean enable) {
        this.modifyMergeControls(enable);
        this.modifyAddControls(!enable);
    }

    private void modifyMergeControls(boolean enabled) {
        this.comboQuantitationCompoundNames.setEnabled(enabled);
        this.textConcentrationMerge.setEnabled(enabled);
        this.labelConcentrationUnitMerge.setEnabled(enabled);
    }

    private void modifyAddControls(boolean enabled) {
        this.comboPeakTargetNames.setEnabled(enabled);
        this.textConcentrationCreate.setEnabled(enabled);
        this.textConcentrationUnitCreate.setEnabled(enabled);
        this.textChemicalClassCreate.setEnabled(enabled);
        this.label1.setEnabled(enabled);
        this.label2.setEnabled(enabled);
        this.label3.setEnabled(enabled);
    }
}

