/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.ui.internal.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.filter.processing.IChromatogramFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.ChromatogramFilterMSD;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.settings.SupplierFilterSettings;
import org.eclipse.chemclipse.model.processor.AbstractChromatogramProcessor;
import org.eclipse.chemclipse.model.processor.IChromatogramProcessor;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIon;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class FilterChromatogramRunnable
extends AbstractChromatogramProcessor
implements IRunnableWithProgress {
    private static final String DESCRIPTION = "Ion Remover Chromatogram Filter";
    private static final String FILTER_ID = "org.eclipse.chemclipse.chromatogram.msd.filter.supplier.ionremover.chromatogram";

    public FilterChromatogramRunnable(IChromatogramSelectionMSD chromatogramSelection) {
        super((IChromatogramSelection)chromatogramSelection);
    }

    public void execute(IProgressMonitor monitor) {
        if (this.getChromatogramSelection() instanceof IChromatogramSelectionMSD) {
            IChromatogramSelectionMSD chromatogramSelection = (IChromatogramSelectionMSD)this.getChromatogramSelection();
            SupplierFilterSettings chromatogramFilterSettings = new SupplierFilterSettings();
            IMarkedIons excludedIons = chromatogramFilterSettings.getIonsToRemove();
            Set ions = new HashSet();
            if (PreferenceSupplier.useSettings()) {
                ions = PreferenceSupplier.getIons();
            } else if (chromatogramSelection != null) {
                ions = chromatogramSelection.getExcludedIons().getIonsNominal();
            }
            Iterator iterator = ions.iterator();
            while (iterator.hasNext()) {
                int ion = (Integer)iterator.next();
                excludedIons.add((Object)new MarkedIon((double)ion));
            }
            IChromatogramFilterProcessingInfo processingInfo = ChromatogramFilterMSD.applyFilter((IChromatogramSelectionMSD)chromatogramSelection, (IChromatogramFilterSettings)chromatogramFilterSettings, (String)FILTER_ID, (IProgressMonitor)monitor);
            ProcessingInfoViewSupport.updateProcessingInfo((IProcessingInfo)processingInfo, (boolean)false);
        }
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Ion Remover Filter", -1);
            this.getChromatogramSelection().getChromatogram().doOperation((IChromatogramProcessor)this, monitor);
        }
        finally {
            monitor.done();
        }
    }
}

