/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import org.ejml.data.CD1Matrix64F;
import org.ejml.data.Complex64F;
import org.ejml.data.ComplexMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.ops.MatrixIO;

public class CDenseMatrix64F
extends CD1Matrix64F {
    public CDenseMatrix64F(double[][] data) {
        this.numRows = data.length;
        this.numCols = data[0].length / 2;
        this.data = new double[this.numRows * this.numCols * 2];
        int i = 0;
        while (i < this.numRows) {
            double[] row = data[i];
            if (row.length != this.numCols * 2) {
                throw new IllegalArgumentException("Unexpected row size in input data at row " + i);
            }
            System.arraycopy(row, 0, this.data, i * this.numCols * 2, row.length);
            ++i;
        }
    }

    public CDenseMatrix64F(int numRows, int numCols, boolean rowMajor, double ... data) {
        if (data.length != numRows * numCols * 2) {
            throw new RuntimeException("Unexpected length for data");
        }
        this.data = new double[numRows * numCols * 2];
        this.numRows = numRows;
        this.numCols = numCols;
        this.set(numRows, numCols, rowMajor, data);
    }

    public CDenseMatrix64F(CDenseMatrix64F original) {
        this(original.numRows, original.numCols);
        this.set(original);
    }

    public CDenseMatrix64F(int numRows, int numCols) {
        this.numRows = numRows;
        this.numCols = numCols;
        this.data = new double[numRows * numCols * 2];
    }

    @Override
    public int getIndex(int row, int col) {
        return row * this.numCols * 2 + col * 2;
    }

    @Override
    public void reshape(int numRows, int numCols) {
        int newLength = numRows * numCols * 2;
        if (newLength > this.data.length) {
            this.data = new double[newLength];
        }
        this.numRows = numRows;
        this.numCols = numCols;
    }

    @Override
    public void get(int row, int col, Complex64F output) {
        int index = row * this.numCols * 2 + col * 2;
        output.real = this.data[index];
        output.imaginary = this.data[index + 1];
    }

    @Override
    public void set(int row, int col, double real, double imaginary) {
        int index = row * this.numCols * 2 + col * 2;
        this.data[index] = real;
        this.data[index + 1] = imaginary;
    }

    @Override
    public double getReal(int row, int col) {
        return this.data[row * this.numCols * 2 + col * 2];
    }

    @Override
    public void setReal(int row, int col, double val) {
        this.data[row * this.numCols * 2 + col * 2] = val;
    }

    @Override
    public double getImaginary(int row, int col) {
        return this.data[row * this.numCols * 2 + col * 2 + 1];
    }

    @Override
    public void setImaginary(int row, int col, double val) {
        this.data[row * this.numCols * 2 + col * 2 + 1] = val;
    }

    @Override
    public int getDataLength() {
        return this.numRows * this.numCols * 2;
    }

    public void set(CDenseMatrix64F original) {
        this.reshape(original.numRows, original.numCols);
        int columnSize = this.numCols * 2;
        int y = 0;
        while (y < this.numRows) {
            int index = y * this.numCols * 2;
            System.arraycopy(original.data, index, this.data, index, columnSize);
            ++y;
        }
    }

    public CDenseMatrix64F copy() {
        return new CDenseMatrix64F(this);
    }

    @Override
    public void set(Matrix original) {
        this.reshape(original.getNumRows(), original.getNumCols());
        ComplexMatrix64F n = (ComplexMatrix64F)original;
        Complex64F c = new Complex64F();
        int i = 0;
        while (i < this.numRows) {
            int j = 0;
            while (j < this.numCols) {
                n.get(i, j, c);
                this.set(i, j, c.real, c.imaginary);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void print() {
        MatrixIO.print(System.out, this);
    }

    public int getRowStride() {
        return this.numCols * 2;
    }

    public void set(int numRows, int numCols, boolean rowMajor, double ... data) {
        this.reshape(numRows, numCols);
        int length = numRows * numCols * 2;
        if (length > data.length) {
            throw new RuntimeException("Passed in array not long enough");
        }
        if (rowMajor) {
            System.arraycopy(data, 0, this.data, 0, length);
        } else {
            int index = 0;
            int stride = numRows * 2;
            int i = 0;
            while (i < numRows) {
                int j = 0;
                while (j < numCols) {
                    this.data[index++] = data[j * stride + i * 2];
                    this.data[index++] = data[j * stride + i * 2 + 1];
                    ++j;
                }
                ++i;
            }
        }
    }
}

