/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.lu;

import org.ejml.alg.dense.decomposition.lu.LUDecompositionBase_D64;
import org.ejml.data.DenseMatrix64F;

public class LUDecompositionNR_D64
extends LUDecompositionBase_D64 {
    private static final double TINY = 1.0E-40;

    @Override
    public boolean decompose(DenseMatrix64F orig) {
        this.decomposeCommonInit(orig);
        int i = 0;
        while (i < this.m) {
            double big = 0.0;
            int j = 0;
            while (j < this.n) {
                double temp = Math.abs(this.dataLU[i * this.n + j]);
                if (big < temp) {
                    big = temp;
                }
                ++j;
            }
            if (big == 0.0) {
                big = 1.0;
            }
            this.vv[i] = 1.0 / big;
            ++i;
        }
        int k = 0;
        while (k < this.n) {
            int imax = -1;
            double big = 0.0;
            int i2 = k;
            while (i2 < this.m) {
                double temp = this.vv[i2] * this.dataLU[i2 * this.n + k];
                if (temp < 0.0) {
                    temp = -temp;
                }
                if (temp > big) {
                    big = temp;
                    imax = i2;
                }
                ++i2;
            }
            if (imax < 0) {
                this.indx[k] = -1;
                return true;
            }
            if (k != imax) {
                int imax_n = imax * this.n;
                int k_n = k * this.n;
                int end = k_n + this.n;
                while (k_n < end) {
                    double temp = this.dataLU[imax_n];
                    this.dataLU[imax_n] = this.dataLU[k_n];
                    this.dataLU[k_n] = temp;
                    ++imax_n;
                    ++k_n;
                }
                this.pivsign = -this.pivsign;
                this.vv[imax] = this.vv[k];
                int z = this.pivot[imax];
                this.pivot[imax] = this.pivot[k];
                this.pivot[k] = z;
            }
            this.indx[k] = imax;
            double element_kk = this.dataLU[k * this.n + k];
            if (element_kk == 0.0) {
                this.dataLU[k * this.n + k] = 1.0E-40;
                element_kk = 1.0E-40;
            }
            int i3 = k + 1;
            while (i3 < this.m) {
                int i_n = i3 * this.n;
                int n = i_n + k;
                double d = this.dataLU[n] / element_kk;
                this.dataLU[n] = d;
                double temp = d;
                int k_n = k * this.n + k + 1;
                int end = i_n + this.n;
                i_n += k + 1;
                while (i_n < end) {
                    int n2 = i_n++;
                    this.dataLU[n2] = this.dataLU[n2] - temp * this.dataLU[k_n];
                    ++k_n;
                }
                ++i3;
            }
            ++k;
        }
        return true;
    }
}

