/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition;

public class TriangularSolver {
    public static void invertLower(double[] L, int m) {
        int i = 0;
        while (i < m) {
            double L_ii = L[i * m + i];
            int j = 0;
            while (j < i) {
                double val = 0.0;
                int k = j;
                while (k < i) {
                    val += L[i * m + k] * L[k * m + j];
                    ++k;
                }
                L[i * m + j] = -val / L_ii;
                ++j;
            }
            L[i * m + i] = 1.0 / L_ii;
            ++i;
        }
    }

    public static void invertLower(double[] L, double[] L_inv, int m) {
        int i = 0;
        while (i < m) {
            double L_ii = L[i * m + i];
            int j = 0;
            while (j < i) {
                double val = 0.0;
                int k = j;
                while (k < i) {
                    val -= L[i * m + k] * L_inv[k * m + j];
                    ++k;
                }
                L_inv[i * m + j] = val / L_ii;
                ++j;
            }
            L_inv[i * m + i] = 1.0 / L_ii;
            ++i;
        }
    }

    public static void solveL(double[] L, double[] b, int n) {
        int i = 0;
        while (i < n) {
            double sum = b[i];
            int indexL = i * n;
            int k = 0;
            while (k < i) {
                sum -= L[indexL++] * b[k];
                ++k;
            }
            b[i] = sum / L[indexL];
            ++i;
        }
    }

    public static void solveL(double[] L, double[] b, int m, int n) {
        int j = 0;
        while (j < n) {
            int i = 0;
            while (i < m) {
                double sum = b[i * n + j];
                int k = 0;
                while (k < i) {
                    sum -= L[i * m + k] * b[k * n + j];
                    ++k;
                }
                b[i * n + j] = sum / L[i * m + i];
                ++i;
            }
            ++j;
        }
    }

    public static void solveTranL(double[] L, double[] b, int n) {
        int i = n - 1;
        while (i >= 0) {
            double sum = b[i];
            int k = i + 1;
            while (k < n) {
                sum -= L[k * n + i] * b[k];
                ++k;
            }
            b[i] = sum / L[i * n + i];
            --i;
        }
    }

    public static void solveU(double[] U, double[] b, int n) {
        int i = n - 1;
        while (i >= 0) {
            double sum = b[i];
            int indexU = i * n + i + 1;
            int j = i + 1;
            while (j < n) {
                sum -= U[indexU++] * b[j];
                ++j;
            }
            b[i] = sum / U[i * n + i];
            --i;
        }
    }

    public static void solveU(double[] U, double[] b, int sideLength, int minRow, int maxRow) {
        int i = maxRow - 1;
        while (i >= minRow) {
            double sum = b[i];
            int indexU = i * sideLength + i + 1;
            int j = i + 1;
            while (j < maxRow) {
                sum -= U[indexU++] * b[j];
                ++j;
            }
            b[i] = sum / U[i * sideLength + i];
            --i;
        }
    }

    public static void solveU(double[] U, int startU, int strideU, int widthU, double[] b, int startB, int strideB, int widthB) {
        int colB = 0;
        while (colB < widthB) {
            int i = widthU - 1;
            while (i >= 0) {
                double sum = b[startB + i * strideB + colB];
                int j = i + 1;
                while (j < widthU) {
                    sum -= U[startU + i * strideU + j] * b[startB + j * strideB + colB];
                    ++j;
                }
                b[startB + i * strideB + colB] = sum / U[startU + i * strideU + i];
                --i;
            }
            ++colB;
        }
    }
}

