/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decompose.lu;

import org.ejml.alg.dense.decompose.lu.LUDecompositionBase_CD64;
import org.ejml.data.CDenseMatrix64F;

public class LUDecompositionAlt_CD64
extends LUDecompositionBase_CD64 {
    @Override
    public boolean decompose(CDenseMatrix64F a) {
        this.decomposeCommonInit(a);
        double[] LUcolj = this.vv;
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                LUcolj[i * 2] = this.dataLU[i * this.stride + j * 2];
                LUcolj[i * 2 + 1] = this.dataLU[i * this.stride + j * 2 + 1];
                ++i;
            }
            i = 0;
            while (i < this.m) {
                int rowIndex = i * this.stride;
                int kmax = i < j ? i : j;
                double realS = 0.0;
                double imgS = 0.0;
                int k = 0;
                while (k < kmax) {
                    double realD = this.dataLU[rowIndex + k * 2];
                    double imgD = this.dataLU[rowIndex + k * 2 + 1];
                    double realCol = LUcolj[k * 2];
                    double imgCol = LUcolj[k * 2 + 1];
                    realS += realD * realCol - imgD * imgCol;
                    imgS += realD * imgCol + imgD * realCol;
                    ++k;
                }
                int n = i * 2;
                double d = LUcolj[n] - realS;
                LUcolj[n] = d;
                this.dataLU[rowIndex + j * 2] = d;
                int n2 = i * 2 + 1;
                double d2 = LUcolj[n2] - imgS;
                LUcolj[n2] = d2;
                this.dataLU[rowIndex + j * 2 + 1] = d2;
                ++i;
            }
            int p = j;
            double max = LUDecompositionAlt_CD64.mag(LUcolj, p * 2);
            int i2 = j + 1;
            while (i2 < this.m) {
                double v = LUDecompositionAlt_CD64.mag(LUcolj, i2 * 2);
                if (v > max) {
                    p = i2;
                    max = v;
                }
                ++i2;
            }
            if (p != j) {
                int rowP = p * this.stride;
                int rowJ = j * this.stride;
                int endP = rowP + this.stride;
                while (rowP < endP) {
                    double t = this.dataLU[rowP];
                    this.dataLU[rowP] = this.dataLU[rowJ];
                    this.dataLU[rowJ] = t;
                    ++rowP;
                    ++rowJ;
                }
                int k = this.pivot[p];
                this.pivot[p] = this.pivot[j];
                this.pivot[j] = k;
                this.pivsign = -this.pivsign;
            }
            this.indx[j] = p;
            if (j < this.m) {
                double realLujj = this.dataLU[j * this.stride + j * 2];
                double imgLujj = this.dataLU[j * this.stride + j * 2 + 1];
                double magLujj = realLujj * realLujj + imgLujj * imgLujj;
                if (realLujj != 0.0 || imgLujj != 0.0) {
                    int i3 = j + 1;
                    while (i3 < this.m) {
                        double realLU = this.dataLU[i3 * this.stride + j * 2];
                        double imagLU = this.dataLU[i3 * this.stride + j * 2 + 1];
                        this.dataLU[i3 * this.stride + j * 2] = (realLU * realLujj + imagLU * imgLujj) / magLujj;
                        this.dataLU[i3 * this.stride + j * 2 + 1] = (imagLU * realLujj - realLU * imgLujj) / magLujj;
                        ++i3;
                    }
                }
            }
            ++j;
        }
        return true;
    }

    private static double mag(double[] d, int index) {
        double r = d[index];
        double i = d[index + 1];
        return r * r + i * i;
    }
}

