/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow.event;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;

public class HideRowPositionsEvent
extends RowStructuralChangeEvent {
    public HideRowPositionsEvent(ILayer layer, Collection<Integer> rowPositions) {
        super(layer, PositionUtil.getRanges(rowPositions));
    }

    protected HideRowPositionsEvent(HideRowPositionsEvent event) {
        super(event);
    }

    @Override
    public HideRowPositionsEvent cloneEvent() {
        return new HideRowPositionsEvent(this);
    }

    @Override
    public Collection<StructuralDiff> getRowDiffs() {
        ArrayList<StructuralDiff> rowDiffs = new ArrayList<StructuralDiff>();
        for (Range range : this.getRowPositionRanges()) {
            StructuralDiff diff = new StructuralDiff(StructuralDiff.DiffTypeEnum.DELETE, range, new Range(range.start, range.start));
            rowDiffs.add(diff);
        }
        return rowDiffs;
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        super.convertToLocal(localLayer);
        return true;
    }
}

