/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.editor;

import org.cloudfoundry.client.lib.domain.CloudService;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.ui.internal.actions.AddServicesToApplicationAction;
import org.eclipse.cft.server.ui.internal.editor.CloudFoundryApplicationsEditorPage;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;

public class ServicesViewerDropListener
extends ViewerDropAdapter {
    private final CloudFoundryApplicationsEditorPage editorPage;
    private CloudFoundryApplicationModule appModule;
    private final CloudFoundryServerBehaviour serverBehaviour;

    protected ServicesViewerDropListener(Viewer viewer, CloudFoundryServerBehaviour serverBehaviour, CloudFoundryApplicationsEditorPage editorPage) {
        super(viewer);
        this.serverBehaviour = serverBehaviour;
        this.editorPage = editorPage;
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16 || event.detail == 0) {
            event.detail = 1;
        }
        super.dragEnter(event);
    }

    public boolean performDrop(Object data) {
        IStructuredSelection selection = (IStructuredSelection)data;
        new AddServicesToApplicationAction(selection, this.appModule, this.serverBehaviour, this.editorPage).run();
        return true;
    }

    public void setModule(CloudFoundryApplicationModule module) {
        this.appModule = module;
    }

    public boolean validateDrop(Object target, int operation, TransferData type) {
        this.overrideOperation(1);
        if ((operation == 1 || operation == 16) && LocalSelectionTransfer.getTransfer().isSupportedType(type)) {
            Object[] objects;
            IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
            Object[] objectArray = objects = selection.toArray();
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof CloudService) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

