/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.application;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.cft.server.core.CFApplicationArchive;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryProjectUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerUtil;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.application.ICloudFoundryArchiver;
import org.eclipse.cft.server.core.internal.application.ManifestParser;
import org.eclipse.cft.server.core.internal.application.ZipArchive;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IModuleResource;

public class ManifestApplicationArchiver
implements ICloudFoundryArchiver {
    @Override
    public CFApplicationArchive getApplicationArchive(IModule module, IServer server, IModuleResource[] resources, IProgressMonitor monitor) throws CoreException {
        CloudFoundryServer cloudServer = CloudServerUtil.getCloudServer(server);
        CloudFoundryApplicationModule appModule = CloudServerUtil.getCloudFoundryApplicationModule(module, server);
        return this.getArchiveFromManifest(appModule, cloudServer);
    }

    public CFApplicationArchive getArchiveFromManifest(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) throws CoreException {
        String archivePath = null;
        ManifestParser parser = new ManifestParser(appModule, cloudServer);
        if (parser.hasManifest()) {
            archivePath = parser.getApplicationProperty(null, "path");
        }
        File packagedFile = null;
        if (archivePath != null) {
            Path path = new Path(archivePath);
            if (path.getFileExtension() != null) {
                IFile projectRelativeFile = null;
                IProject project = CloudFoundryProjectUtil.getProject(appModule);
                if (project != null) {
                    projectRelativeFile = project.getFile(archivePath);
                }
                if (projectRelativeFile != null && projectRelativeFile.exists()) {
                    packagedFile = projectRelativeFile.getLocation().toFile();
                } else {
                    File absoluteFile = new File(archivePath);
                    if (absoluteFile.exists() && absoluteFile.canRead()) {
                        packagedFile = absoluteFile;
                    }
                }
            }
            if (packagedFile == null) {
                String message = NLS.bind((String)Messages.JavaWebApplicationDelegate_ERROR_FILE_NOT_FOUND_MANIFEST_YML, (Object)archivePath);
                throw CloudErrorUtil.toCoreException(message);
            }
            try {
                return new ZipArchive(new ZipFile(packagedFile));
            }
            catch (ZipException e) {
                throw CloudErrorUtil.toCoreException(e);
            }
            catch (IOException e) {
                throw CloudErrorUtil.toCoreException(e);
            }
        }
        return null;
    }
}

