/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.eclipse.cft.server.core.CFServiceInstance;
import org.eclipse.cft.server.core.EnvironmentVariable;

public class ApplicationDeploymentInfo
extends Observable {
    private List<EnvironmentVariable> envVars = new ArrayList<EnvironmentVariable>();
    private int instances;
    private String name;
    private List<String> uris;
    private List<CFServiceInstance> services;
    private int memory;
    private String archive;
    private String buildpack;

    public ApplicationDeploymentInfo(String appName) {
        this.setDeploymentName(appName);
    }

    public void setEnvVariables(List<EnvironmentVariable> envVars) {
        this.envVars.clear();
        if (envVars != null) {
            this.envVars.addAll(envVars);
            this.setChanged();
            this.notifyObservers(envVars);
        }
    }

    public List<EnvironmentVariable> getEnvVariables() {
        return new ArrayList<EnvironmentVariable>(this.envVars);
    }

    public int getInstances() {
        return this.instances;
    }

    public void setInstances(int instances) {
        this.instances = instances;
    }

    public String getBuildpack() {
        return this.buildpack;
    }

    public void setBuildpack(String buildpack) {
        this.buildpack = buildpack;
    }

    public String getDeploymentName() {
        return this.name;
    }

    public void setDeploymentName(String name) {
        this.name = name;
        this.setChanged();
        this.notifyObservers(name);
    }

    public void setUris(List<String> uris) {
        this.uris = uris;
    }

    public List<String> getUris() {
        return this.uris;
    }

    public List<CFServiceInstance> getServices() {
        return this.services;
    }

    public List<String> asServiceBindingList() {
        ArrayList<String> bindingList = new ArrayList<String>();
        if (this.services != null && !this.services.isEmpty()) {
            for (CFServiceInstance service : this.services) {
                bindingList.add(service.getName());
            }
        }
        return bindingList;
    }

    public void setServices(List<CFServiceInstance> services) {
        this.services = services;
    }

    public int getMemory() {
        return this.memory;
    }

    public void setMemory(int memory) {
        this.memory = memory;
    }

    public String getArchive() {
        return this.archive;
    }

    public void setArchive(String archive) {
        this.archive = archive;
    }

    public void setInfo(ApplicationDeploymentInfo info) {
        if (info == null) {
            return;
        }
        this.setDeploymentName(info.getDeploymentName());
        this.setMemory(info.getMemory());
        this.setBuildpack(info.getBuildpack());
        this.setInstances(info.getInstances());
        this.setArchive(info.getArchive());
        if (info.getServices() != null) {
            this.setServices(new ArrayList<CFServiceInstance>(info.getServices()));
        } else {
            this.setServices(null);
        }
        if (info.getUris() != null) {
            this.setUris(new ArrayList<String>(info.getUris()));
        } else {
            this.setUris(null);
        }
        if (info.getEnvVariables() != null) {
            this.setEnvVariables(new ArrayList<EnvironmentVariable>(info.getEnvVariables()));
        } else {
            this.setEnvVariables(null);
        }
    }

    public ApplicationDeploymentInfo copy() {
        ApplicationDeploymentInfo info = new ApplicationDeploymentInfo(this.getDeploymentName());
        info.setMemory(this.getMemory());
        info.setBuildpack(this.getBuildpack());
        info.setInstances(this.getInstances());
        info.setArchive(this.getArchive());
        if (this.getServices() != null) {
            info.setServices(new ArrayList<CFServiceInstance>(this.getServices()));
        }
        if (this.getUris() != null) {
            info.setUris(new ArrayList<String>(this.getUris()));
        }
        if (this.getEnvVariables() != null) {
            info.setEnvVariables(new ArrayList<EnvironmentVariable>(this.getEnvVariables()));
        }
        return info;
    }
}

