/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.cloudfoundry.client.lib.domain.Staging;
import org.eclipse.cft.server.core.ApplicationDeploymentInfo;
import org.eclipse.cft.server.core.internal.ApplicationAction;
import org.eclipse.core.runtime.Assert;

public class ApplicationWizardDescriptor {
    private final ApplicationDeploymentInfo deploymentInfo;
    private List<CloudService> createdCloudServices;
    private boolean persistDeploymentInfo;
    private ApplicationAction applicationStartMode;

    public ApplicationWizardDescriptor(ApplicationDeploymentInfo deploymentInfo) {
        Assert.isNotNull((Object)deploymentInfo);
        this.deploymentInfo = deploymentInfo;
    }

    public void setStartCommand(String startCommand) {
        Staging staging = this.deploymentInfo.getStaging();
        String buildpackUrl = staging != null ? staging.getBuildpackUrl() : null;
        staging = new Staging(startCommand, buildpackUrl);
        this.deploymentInfo.setStaging(staging);
    }

    public void setBuildpack(String buildpack) {
        Staging staging = this.deploymentInfo.getStaging();
        String existingStartCommand = staging != null ? staging.getCommand() : null;
        staging = new Staging(existingStartCommand, buildpack);
        this.deploymentInfo.setStaging(staging);
    }

    public List<CloudService> getCloudServicesToCreate() {
        return this.createdCloudServices;
    }

    public void setCloudServicesToCreate(List<CloudService> createdCloudServices) {
        this.createdCloudServices = createdCloudServices;
    }

    public void setApplicationStartMode(ApplicationAction applicationStartMode) {
        this.applicationStartMode = applicationStartMode;
    }

    public ApplicationAction getApplicationStartMode() {
        return this.applicationStartMode;
    }

    public ApplicationDeploymentInfo getDeploymentInfo() {
        return this.deploymentInfo;
    }

    public void persistDeploymentInfo(boolean persist) {
        this.persistDeploymentInfo = persist;
    }

    public boolean shouldPersistDeploymentInfo() {
        return this.persistDeploymentInfo;
    }
}

