/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.editor;

import org.cloudfoundry.client.lib.domain.CloudService;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.editor.ServiceViewColumn;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableColumn;

public class ServicesTreeLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final TableViewer viewer;

    public ServicesTreeLabelProvider(TableViewer viewer) {
        this.viewer = viewer;
    }

    public Image getImage(Object element) {
        if (element instanceof CloudService) {
            return CloudFoundryImages.getImage(CloudFoundryImages.OBJ_SERVICE);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof CloudService) {
            CloudService service = (CloudService)element;
            return service.getName();
        }
        return super.getText(element);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        TableColumn column = this.viewer.getTable().getColumn(columnIndex);
        if (column != null && column.getData() instanceof ServiceViewColumn) {
            switch ((ServiceViewColumn)((Object)column.getData())) {
                case Name: {
                    return this.getImage(element);
                }
            }
            return this.getColumnImage((CloudService)element, (ServiceViewColumn)((Object)column.getData()));
        }
        return null;
    }

    protected Image getColumnImage(CloudService service, ServiceViewColumn column) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String result = null;
        TableColumn column = this.viewer.getTable().getColumn(columnIndex);
        if (column != null && element instanceof CloudService) {
            CloudService cloudService = (CloudService)element;
            ServiceViewColumn serviceColumn = (ServiceViewColumn)((Object)column.getData());
            if (serviceColumn != null) {
                switch (serviceColumn) {
                    case Name: {
                        result = this.getText(element);
                        break;
                    }
                    case Version: {
                        result = cloudService.getVersion();
                        break;
                    }
                    case Vendor: {
                        result = cloudService.getLabel();
                        break;
                    }
                    case Plan: {
                        result = cloudService.getPlan();
                        break;
                    }
                    case Provider: {
                        result = cloudService.getProvider();
                    }
                }
            }
        }
        return result;
    }
}

