/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.AbstractWaitWithProgressJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

public class CloudFoundryLoginHandler {
    private final CloudFoundryOperations operations;
    private static final String DEFAULT_PROGRESS_LABEL = Messages.CloudFoundryLoginHandler_LABEL_PERFORM_CF_OPERATION;
    private static final int DEFAULT_PROGRESS_TICKS = 100;

    public CloudFoundryLoginHandler(CloudFoundryOperations operations) {
        this.operations = operations;
    }

    public OAuth2AccessToken login(IProgressMonitor monitor) throws CoreException {
        return this.login(monitor, 1, 0L);
    }

    public OAuth2AccessToken login(IProgressMonitor monitor, int tries, long sleep) throws CoreException {
        return this.internalLogin(monitor, tries, sleep);
    }

    protected OAuth2AccessToken internalLogin(IProgressMonitor monitor, int tries, long sleep) throws CoreException {
        return (OAuth2AccessToken)new AbstractWaitWithProgressJob<OAuth2AccessToken>(tries, sleep){

            @Override
            protected OAuth2AccessToken runInWait(IProgressMonitor monitor) throws CoreException {
                return CloudFoundryLoginHandler.this.operations.login();
            }

            @Override
            protected boolean shouldRetryOnError(Throwable t) {
                return CloudFoundryLoginHandler.this.shouldAttemptClientLogin(t);
            }
        }.run(monitor);
    }

    protected SubMonitor getProgressMonitor(IProgressMonitor progressMonitor) {
        return progressMonitor instanceof SubMonitor ? (SubMonitor)progressMonitor : SubMonitor.convert((IProgressMonitor)progressMonitor, (String)DEFAULT_PROGRESS_LABEL, (int)100);
    }

    public boolean shouldAttemptClientLogin(Throwable t) {
        return CloudErrorUtil.getInvalidCredentialsError(t) != null;
    }

    public boolean updateProxyInClient(CloudFoundryOperations client) throws CoreException {
        return false;
    }
}

