/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.lib.archive.ApplicationArchive;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.eclipse.cft.server.core.ApplicationDeploymentInfo;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.ValueValidationUtil;
import org.eclipse.cft.server.core.internal.application.EnvironmentVariable;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.LocalCloudService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;

public abstract class AbstractApplicationDelegate {
    public abstract boolean requiresURL();

    public abstract boolean providesApplicationArchive(IModule var1);

    public abstract ApplicationArchive getApplicationArchive(CloudFoundryApplicationModule var1, CloudFoundryServer var2, IModuleResource[] var3, IProgressMonitor var4) throws CoreException;

    public IStatus validateDeploymentInfo(ApplicationDeploymentInfo deploymentInfo) {
        return AbstractApplicationDelegate.basicValidateDeploymentInfo(deploymentInfo);
    }

    public ApplicationDeploymentInfo resolveApplicationDeploymentInfo(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) {
        return AbstractApplicationDelegate.parseApplicationDeploymentInfo(appModule.getApplication());
    }

    public ApplicationDeploymentInfo getDefaultApplicationDeploymentInfo(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, IProgressMonitor monitor) throws CoreException {
        String appName = appModule.getDeployedApplicationName();
        ApplicationDeploymentInfo deploymentInfo = new ApplicationDeploymentInfo(appName);
        deploymentInfo.setMemory(512);
        return deploymentInfo;
    }

    public static IStatus basicValidateDeploymentInfo(ApplicationDeploymentInfo deploymentInfo) {
        IStatus status = Status.OK_STATUS;
        String errorMessage = null;
        if (deploymentInfo == null) {
            errorMessage = Messages.AbstractApplicationDelegate_ERROR_MISSING_DEPLOY_INFO;
        } else if (ValueValidationUtil.isEmpty(deploymentInfo.getDeploymentName())) {
            errorMessage = Messages.AbstractApplicationDelegate_ERROR_MISSING_APPNAME;
        } else if (deploymentInfo.getMemory() <= 0) {
            errorMessage = Messages.AbstractApplicationDelegate_ERROR_MISSING_MEM;
        }
        if (errorMessage != null) {
            status = CloudFoundryPlugin.getErrorStatus(errorMessage);
        }
        return status;
    }

    public static ApplicationDeploymentInfo parseApplicationDeploymentInfo(CloudApplication cloudApplication) {
        if (cloudApplication != null) {
            Map envMap;
            String deploymentName = cloudApplication.getName();
            ApplicationDeploymentInfo deploymentInfo = new ApplicationDeploymentInfo(deploymentName);
            deploymentInfo.setInstances(cloudApplication.getInstances());
            deploymentInfo.setStaging(cloudApplication.getStaging());
            deploymentInfo.setMemory(cloudApplication.getMemory());
            List boundServiceNames = cloudApplication.getServices();
            if (boundServiceNames != null) {
                ArrayList<CloudService> services = new ArrayList<CloudService>();
                for (String name : boundServiceNames) {
                    if (name == null) continue;
                    services.add(new LocalCloudService(name));
                }
                deploymentInfo.setServices(services);
            }
            if (cloudApplication.getUris() != null) {
                deploymentInfo.setUris(new ArrayList<String>(cloudApplication.getUris()));
            }
            if ((envMap = cloudApplication.getEnvAsMap()) != null) {
                ArrayList<EnvironmentVariable> variables = new ArrayList<EnvironmentVariable>();
                for (Map.Entry entry : envMap.entrySet()) {
                    String varName = (String)entry.getKey();
                    if (varName == null) continue;
                    EnvironmentVariable variable = new EnvironmentVariable();
                    variable.setVariable(varName);
                    variable.setValue((String)entry.getValue());
                    variables.add(variable);
                }
                deploymentInfo.setEnvVariables(variables);
            }
            return deploymentInfo;
        }
        return null;
    }
}

