/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.application;

import java.io.File;
import java.util.zip.ZipFile;
import org.eclipse.cft.server.core.CFApplicationArchive;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudServerUtil;
import org.eclipse.cft.server.core.internal.CloudUtil;
import org.eclipse.cft.server.core.internal.application.ICloudFoundryArchiver;
import org.eclipse.cft.server.core.internal.application.ZipArchive;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleResource;

public class WarApplicationArchiver
implements ICloudFoundryArchiver {
    @Override
    public CFApplicationArchive getApplicationArchive(IModule module, IServer server, IModuleResource[] resources, IProgressMonitor monitor) throws CoreException {
        CloudFoundryApplicationModule appModule = CloudServerUtil.getCloudFoundryApplicationModule(module, server);
        try {
            if (server instanceof Server) {
                File warFile = CloudUtil.createWarFile(new IModule[]{module}, (Server)server, monitor);
                CloudFoundryPlugin.trace("War file " + warFile.getName() + " created");
                return new ZipArchive(new ZipFile(warFile));
            }
            throw CloudErrorUtil.toCoreException("Expected server: " + server.getId() + " to be of type: " + Server.class.getName() + ". Unable to generate WAR file and deploy the application to the selected server.");
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cft.server.core", "Failed to create war file. \nApplication: " + appModule.getDeployedApplicationName() + "\nModule: " + module.getName() + "\nException: " + e.getMessage(), (Throwable)e));
        }
    }
}

