/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.handler.jdt.notification;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.IArtifactMetaModelAdapter;
import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.handler.jdt.JavaElementHandler;
import org.eclipse.capra.ui.notification.CapraNotificationHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaCore;

public class JavaElementChangeListener
implements IElementChangedListener {
    IArtifactMetaModelAdapter artifactAdapter = (IArtifactMetaModelAdapter)ExtensionPointHelper.getArtifactMetaModelAdapter().orElseThrow();

    public void elementChanged(final ElementChangedEvent event) {
        IPersistenceAdapter tracePersistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().orElseThrow();
        EObject artifactModel = tracePersistenceAdapter.getArtifactWrappers(EditingDomainHelper.getResourceSet());
        List allArtifacts = this.artifactAdapter.getAllArtifacts(artifactModel);
        final List javaArtifacts = allArtifacts.stream().filter(p -> this.artifactAdapter.getArtifactHandler(p).equals(JavaElementHandler.class.getName())).collect(Collectors.toList());
        if (javaArtifacts.isEmpty()) {
            return;
        }
        Path path = new Path(EcoreUtil.getURI((EObject)artifactModel).toPlatformString(false));
        final IFile wrapperContainer = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        new WorkspaceJob("CapraNotificationJob"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                JavaElementChangeListener.this.handleDelta(event.getDelta(), javaArtifacts, wrapperContainer);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void handleDelta(IJavaElementDelta delta, List<EObject> javaArtifacts, IFile wrapperContainer) {
        String affectedElementUri;
        if (!(delta.getElement() instanceof ICompilationUnit)) {
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta subDelta = iJavaElementDeltaArray[n2];
                this.handleDelta(subDelta, javaArtifacts, wrapperContainer);
                ++n2;
            }
        }
        int flags = delta.getFlags();
        int changeType = delta.getKind();
        CapraNotificationHelper.IssueType issueType = null;
        if (changeType == 1) {
            issueType = CapraNotificationHelper.IssueType.ADDED;
        } else if (changeType == 2) {
            issueType = (flags & 0x20) != 0 ? (delta.getMovedToElement().getElementName().equals(delta.getElement().getElementName()) ? CapraNotificationHelper.IssueType.MOVED : CapraNotificationHelper.IssueType.RENAMED) : CapraNotificationHelper.IssueType.DELETED;
        } else if (changeType == 4 && (flags & 0x40000) != 0) {
            issueType = CapraNotificationHelper.IssueType.CHANGED;
        }
        if (issueType != null && (affectedElementUri = delta.getElement().getHandleIdentifier()) != null) {
            for (EObject aw : javaArtifacts) {
                String artifactId = this.artifactAdapter.getArtifactInternalResolver(aw);
                CapraNotificationHelper.IssueType[] markersToDelete = null;
                String deleteMarkerUri = "";
                IJavaElement element = JavaCore.create((String)artifactId);
                if (element != null && element.exists()) {
                    deleteMarkerUri = artifactId;
                    markersToDelete = new CapraNotificationHelper.IssueType[]{CapraNotificationHelper.IssueType.MOVED, CapraNotificationHelper.IssueType.RENAMED, CapraNotificationHelper.IssueType.DELETED};
                } else if (issueType == CapraNotificationHelper.IssueType.DELETED) {
                    markersToDelete = new CapraNotificationHelper.IssueType[]{CapraNotificationHelper.IssueType.MOVED, CapraNotificationHelper.IssueType.RENAMED, CapraNotificationHelper.IssueType.CHANGED};
                    deleteMarkerUri = affectedElementUri;
                }
                if (!deleteMarkerUri.isEmpty() && artifactId.contains(deleteMarkerUri)) {
                    CapraNotificationHelper.deleteCapraMarker((String)artifactId, markersToDelete, (IFile)wrapperContainer);
                }
                if (!artifactId.contains(affectedElementUri)) continue;
                Map<String, String> markerInfo = this.generateMarkerInfo(aw, delta, issueType);
                CapraNotificationHelper.createCapraMarker(markerInfo, (IResource)wrapperContainer);
            }
        }
    }

    private Map<String, String> generateMarkerInfo(EObject aw, IJavaElementDelta delta, CapraNotificationHelper.IssueType issueType) {
        HashMap<String, String> markerInfo = new HashMap<String, String>();
        String oldArtifactUri = this.artifactAdapter.getArtifactInternalResolver(aw);
        String oldArtifactName = this.artifactAdapter.getArtifactName(aw);
        String oldAffectedElementUri = delta.getElement().getHandleIdentifier();
        String oldAffectedElementName = delta.getElement().getElementName();
        String newAffectedElementUri = null;
        String newAffectedElementName = null;
        IJavaElement newAffectedElement = delta.getMovedToElement();
        if (newAffectedElement != null) {
            newAffectedElementUri = newAffectedElement.getHandleIdentifier();
            newAffectedElementName = newAffectedElement.getElementName();
        }
        String message = "";
        switch (issueType) {
            case RENAMED: {
                if (oldArtifactUri.equals(oldAffectedElementUri)) {
                    message = String.valueOf(oldAffectedElementUri) + " has been renamed to " + newAffectedElementUri + ".";
                    break;
                }
                message = String.valueOf(oldAffectedElementName) + ", an ancestor of " + oldArtifactUri + ", has been renamed to " + newAffectedElementName + ".";
                break;
            }
            case MOVED: {
                if (oldArtifactUri.equals(oldAffectedElementUri)) {
                    message = String.valueOf(oldAffectedElementUri) + " has been moved to " + newAffectedElementUri + ".";
                    break;
                }
                message = String.valueOf(oldAffectedElementName) + ", an ancestor of " + oldArtifactUri + ", has been moved to " + newAffectedElementUri;
                break;
            }
            default: {
                IJavaElement el = JavaCore.create((String)oldArtifactUri);
                if (el != null && el.exists()) break;
                issueType = CapraNotificationHelper.IssueType.DELETED;
                message = this.artifactAdapter.getArtifactUri(aw);
                message = el instanceof ISourceReference && !(el instanceof ICompilationUnit) ? String.valueOf(message) + " has been deleted or has had its signature changed." : String.valueOf(message) + " has been deleted.";
            }
        }
        if (newAffectedElementUri != null) {
            String newArtifactName;
            String newArtifactUri;
            if (oldArtifactUri.equals(oldAffectedElementUri)) {
                newArtifactUri = newAffectedElementUri;
                newArtifactName = newAffectedElementName;
            } else {
                newArtifactUri = oldArtifactUri.replace(oldAffectedElementUri, newAffectedElementUri);
                newArtifactName = oldArtifactName;
                if (newAffectedElement instanceof ICompilationUnit) {
                    int classEndIndex;
                    String oldPublicClassName = oldAffectedElementName.replace(".java", "");
                    String newPublicClassName = newAffectedElementName.replace(".java", "");
                    int classStartIndex = newAffectedElementUri.length() + 1;
                    if (newArtifactUri.substring(classStartIndex, classEndIndex = classStartIndex + oldPublicClassName.length()).equals(oldPublicClassName)) {
                        newArtifactUri = String.valueOf(newArtifactUri.substring(0, classStartIndex)) + newPublicClassName + newArtifactUri.substring(classEndIndex);
                    }
                    if (newArtifactName.contentEquals(oldPublicClassName)) {
                        newArtifactName = newPublicClassName;
                    }
                }
            }
            markerInfo.put("newArtifactUri", newArtifactUri);
            markerInfo.put("newArtifactName", newArtifactName);
        }
        markerInfo.put("issueType", issueType.getValue());
        markerInfo.put("oldArtifactUri", oldArtifactUri);
        markerInfo.put("message", message);
        return markerInfo;
    }
}

