/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.commandline;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.producer.MissingExtensionException;
import org.eclipse.egf.model.domain.Domain;
import org.eclipse.egf.model.domain.DomainViewpoint;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.Viewpoint;
import org.eclipse.egf.model.types.Type;
import org.eclipse.egf.model.types.TypeString;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.polarsys.capella.core.commandline.core.AbstractCommandLine;
import org.polarsys.capella.core.commandline.core.CommandLineException;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.docgen.commandline.Messages;
import org.polarsys.kitalpha.doc.gen.business.core.sirius.util.session.DiagramSessionHelper;
import org.polarsys.kitalpha.doc.gen.business.core.ui.helper.InvokeActivityHelper;

public class HTMLCommandLine
extends AbstractCommandLine {
    private static final String FCORE_URI = "/org.polarsys.capella.docgen.ui/egf/capellalauncher.fcore#_zup7kAkdEeCBJtEcjZDVOA";
    private static final URI CAPELLA_LAUNCHER_URI = URI.createURI((String)"platform:/plugin/org.polarsys.capella.docgen.ui/egf/capellalauncher.fcore#_zup7kAkdEeCBJtEcjZDVOA");

    public void printHelp() {
        System.out.println("Capella HTML Command Line");
        super.printHelp();
    }

    public void checkArgs(IApplicationContext context_p) throws CommandLineException {
        super.checkArgs(context_p);
    }

    public boolean execute(IApplicationContext context_p) {
        HTMLCommandLine.startFakeWorkbench();
        String fileURI = String.valueOf(Messages.resource_prefix) + argHelper.getFilePath();
        URI uri = URI.createURI((String)fileURI);
        Activity htmlGenerator = InvokeActivityHelper.getActivity((URI)CAPELLA_LAUNCHER_URI);
        URI semanticResourceURI = uri;
        if (uri.lastSegment().endsWith(".aird")) {
            DiagramSessionHelper.setAirdUri((URI)uri);
            Session session = DiagramSessionHelper.initSession();
            session.open((IProgressMonitor)new NullProgressMonitor());
            Project rootSemanticElement = SessionHelper.getCapellaProject((Session)session);
            if (rootSemanticElement != null) {
                Resource semanticResource = rootSemanticElement.eResource();
                semanticResourceURI = semanticResource.getURI();
                boolean status = this.executeEGFActivity(htmlGenerator, argHelper.getOutputFolder(), semanticResourceURI);
                if (status) {
                    this.logInfo(String.valueOf(Messages.generation_done) + argHelper.getOutputFolder());
                }
            } else {
                this.logError(Messages.no_root_semantic_element);
            }
        } else {
            this.logError(Messages.filepath_point_to_aird);
        }
        return true;
    }

    public void prepare(IApplicationContext context_p) throws CommandLineException {
        super.prepare(context_p);
    }

    public static void startFakeWorkbench() {
        Display display = PlatformUI.createDisplay();
        PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new WorkbenchAdvisor(){

            public boolean openWindows() {
                return false;
            }

            public String getInitialWindowPerspectiveId() {
                return null;
            }
        });
    }

    private boolean executeEGFActivity(Activity capellaLauncher, String outputFolder, URI uri) {
        boolean success = false;
        String prefix = Messages.exec_pb;
        Path path = new Path(outputFolder);
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path.append("output"));
        if (!folder.exists()) {
            try {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                StringBuilder message = new StringBuilder(prefix).append(e.getMessage());
                this.logError(message.toString());
                return false;
            }
        }
        if (capellaLauncher instanceof FactoryComponent) {
            String relativeFilePath = HTMLCommandLine.getRelativeFilePath((String)outputFolder);
            String projectName = HTMLCommandLine.getProjectName((String)outputFolder);
            FactoryComponent factoryComponent = (FactoryComponent)capellaLauncher;
            this.setContract(factoryComponent, "projectName", projectName);
            this.setContract(factoryComponent, "outputFolder", String.valueOf(relativeFilePath) + "/output");
            this.setDomain(factoryComponent, uri);
            try {
                InvokeActivityHelper.invokeOutOfUIThread((Activity)factoryComponent);
                success = true;
            }
            catch (MissingExtensionException e) {
                StringBuilder message = new StringBuilder(prefix).append(e.getMessage());
                this.logError(message.toString());
                return false;
            }
            catch (InvocationException e) {
                StringBuilder message = new StringBuilder(prefix).append(e.getMessage());
                this.logError(message.toString());
                return false;
            }
            catch (CoreException e) {
                StringBuilder message = new StringBuilder(prefix).append(e.getMessage());
                this.logError(message.toString());
                return false;
            }
        } else {
            success = false;
        }
        return success;
    }

    private void setDomain(FactoryComponent factoryComponent, URI uri) {
        DomainViewpoint domainViewpoint;
        Domain domain;
        Viewpoint viewpoint = factoryComponent.getViewpointContainer().getViewpoint(DomainViewpoint.class);
        if (viewpoint instanceof DomainViewpoint && (domain = (Domain)(domainViewpoint = (DomainViewpoint)viewpoint).getDomains().get(0)) instanceof EMFDomain) {
            EMFDomain domainURI = (EMFDomain)domain;
            domainURI.setUri(uri);
        }
    }

    private void setContract(FactoryComponent factoryComponent, String contractName, String value) {
        Contract invokedContract = factoryComponent.getContract(contractName);
        Type type = invokedContract.getType();
        if (type instanceof TypeString) {
            TypeString typeString = (TypeString)type;
            typeString.setValue(value);
        }
    }
}

