/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.configuration.ui.viewer.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class SessionContentProvider
implements ITreeContentProvider {
    private static final Object[] empty = new Object[0];
    private AdapterFactoryContentProvider semanticProvider;
    private Session session;

    public SessionContentProvider(Session sessionToProvideFor) {
        this.session = sessionToProvideFor;
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.semanticProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory);
    }

    public Object[] getChildren(Object parentElement_p) {
        Object[] children = empty;
        if (parentElement_p instanceof Session) {
            Session session = (Session)parentElement_p;
            ArrayList capellaElements = new ArrayList();
            Collection semanticResources = SessionHelper.getSemanticResources((Session)session);
            for (Resource resource : semanticResources) {
                if (!CapellaResourceHelper.isCapellaResource((Resource)resource)) continue;
                for (EObject root : resource.getContents()) {
                    if (!(root instanceof Project)) continue;
                    capellaElements.addAll(((Project)root).getOwnedModelRoots());
                }
            }
            children = capellaElements.toArray();
        } else if (parentElement_p instanceof EObject && !(parentElement_p instanceof DRepresentationDescriptor)) {
            EObject parent = (EObject)parentElement_p;
            Collection<DRepresentationDescriptor> representations = this.findRepDescriptors(parent);
            Object[] semantic = this.semanticProvider.getChildren(parentElement_p);
            semantic = this.filtersSemanticFromAnotherResource(parent.eResource(), semantic);
            Object[] result = new Object[representations.size() + semantic.length];
            System.arraycopy(semantic, 0, result, 0, semantic.length);
            int i = semantic.length;
            Iterator<DRepresentationDescriptor> iterRepresentation = representations.iterator();
            while (iterRepresentation.hasNext()) {
                result[i++] = iterRepresentation.next();
            }
            children = result;
        }
        return children;
    }

    private Object[] filtersSemanticFromAnotherResource(Resource resource_p, Object[] semantic_p) {
        Object object;
        ArrayList<Object> filtered = new ArrayList<Object>();
        Object[] objectArray = semantic_p;
        int n = semantic_p.length;
        int n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            filtered.add(object);
            ++n2;
        }
        objectArray = semantic_p;
        n = semantic_p.length;
        n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            if (object instanceof EObject && ((EObject)object).eResource() != null && resource_p != ((EObject)object).eResource() && this.session.getSemanticResources().contains(((EObject)object).eResource())) {
                filtered.remove(object);
            }
            ++n2;
        }
        return filtered.toArray();
    }

    public Object getParent(Object element_p) {
        if (element_p instanceof EObject) {
            EObject current = (EObject)element_p;
            EObject parent = current instanceof DRepresentationDescriptor ? ((DRepresentationDescriptor)current).getTarget() : current.eContainer();
            return parent;
        }
        return null;
    }

    public boolean hasChildren(Object element_p) {
        return this.getChildren(element_p).length > 0;
    }

    public Object[] getElements(Object inputElement_p) {
        return this.getChildren(inputElement_p);
    }

    public void dispose() {
        this.semanticProvider.dispose();
    }

    public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
    }

    private Collection<DRepresentationDescriptor> findRepDescriptors(EObject semanticElement_p) {
        if (semanticElement_p == null) {
            return Collections.emptySet();
        }
        return DialectManager.INSTANCE.getRepresentationDescriptors(semanticElement_p, this.session);
    }
}

