/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.ui.helper;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egf.core.domain.TargetPlatformResourceSet;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.producer.MissingExtensionException;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.pattern.EGFPatternPlugin;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.manager.ActivityManagerProducer;
import org.eclipse.egf.producer.manager.IActivityManager;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.polarsys.kitalpha.doc.gen.business.core.ui.Messages;
import org.polarsys.kitalpha.doc.gen.business.core.util.MonitorServices;

public class InvokeActivityHelper {
    private static EditingDomain editingDomain;

    public static boolean validateAndInvoke(Activity activity) {
        Shell shell;
        Diagnostic diagnostic;
        block5: {
            diagnostic = Diagnostician.INSTANCE.validate((EObject)activity);
            shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            if (diagnostic.getSeverity() == 4) break block5;
            InvokeActivityHelper.invoke(activity);
            return true;
        }
        try {
            MessageDialog.openError((Shell)shell, (String)Messages.InvokeActivityHelper_Error, (String)diagnostic.getMessage());
        }
        catch (MissingExtensionException e) {
            e.printStackTrace();
        }
        catch (InvocationException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void invokeOutOfUIThread(Activity activity) throws MissingExtensionException, InvocationException, CoreException {
        ActivityManagerProducer producer = EGFProducerPlugin.getActivityManagerProducer((Activity)activity);
        final IActivityManager activityManager = producer.createActivityManager(activity);
        activityManager.initializeContext();
        IWorkbench wb = PlatformUI.getWorkbench();
        final IProgressService ps = wb.getProgressService();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ps.busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            try {
                                MonitorServices.initMonitor((IProgressMonitor)monitor);
                                MonitorServices.init((int)0);
                                activityManager.invoke(monitor);
                                activityManager.dispose();
                                MonitorServices.dispose();
                            }
                            catch (Exception e) {
                                EGFPatternPlugin.getDefault().logError((Throwable)e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void invoke(Activity activity, IProgressMonitor monitor) throws MissingExtensionException, InvocationException, CoreException {
        ActivityManagerProducer producer = EGFProducerPlugin.getActivityManagerProducer((Activity)activity);
        IActivityManager activityManager = producer.createActivityManager(activity);
        activityManager.initializeContext();
        try {
            MonitorServices.initMonitor((IProgressMonitor)monitor);
            MonitorServices.init((int)0);
            activityManager.invoke(monitor);
            activityManager.dispose();
            MonitorServices.dispose();
        }
        catch (Exception e) {
            EGFPatternPlugin.getDefault().logError((Throwable)e);
        }
    }

    public static void invoke(Activity activity) throws MissingExtensionException, InvocationException, CoreException {
        ActivityManagerProducer producer = EGFProducerPlugin.getActivityManagerProducer((Activity)activity);
        final IActivityManager activityManager = producer.createActivityManager(activity);
        activityManager.initializeContext();
        Job job = new Job(Messages.InvokeActivityHelper_HTML_Documentation_Generation){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    MonitorServices.initMonitor((IProgressMonitor)monitor);
                    MonitorServices.init((int)0);
                    activityManager.invoke(monitor);
                    activityManager.dispose();
                    MonitorServices.dispose();
                }
                catch (Exception e) {
                    EGFPatternPlugin.getDefault().logError((Throwable)e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public static Activity getActivity(URI activityURI) {
        EditingDomain editingDomain = InvokeActivityHelper.getEditingDomain();
        ResourceSet rs = editingDomain.getResourceSet();
        return (Activity)rs.getEObject(activityURI, true);
    }

    private static EditingDomain getEditingDomain() {
        if (editingDomain == null) {
            InvokeActivityHelper.initializeEditingDomain();
        }
        return editingDomain;
    }

    private static void initializeEditingDomain() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        BasicCommandStack statck = new BasicCommandStack();
        TargetPlatformResourceSet resourceSet = new TargetPlatformResourceSet();
        editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)statck, (ResourceSet)resourceSet);
    }
}

