/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.activities;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.polarsys.capella.core.data.capellacore.TypedElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.transition.common.activities.AbstractActivity;
import org.polarsys.capella.transition.system2subsystem.context.SubSystemContextHelper;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.api.ITransposerWorkflow;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class RootComponentNameUpdater
extends AbstractActivity
implements ITransposerWorkflow {
    public static final String ID = "org.polarsys.capella.transition.system2subsystem.activities.RootComponentNameUpdater";

    protected IStatus _run(ActivityParameters activityParams) {
        IContext context = (IContext)activityParams.getParameter("TransposerContext").getValue();
        List selection = ((Collection)context.get((Object)"TRANSITION_SOURCES")).stream().filter(Component.class::isInstance).map(Component.class::cast).collect(Collectors.toList());
        if (selection.size() == 1) {
            String newName = ((Component)selection.get(0)).getName();
            this.updateRootComponentNames(SubSystemContextHelper.getTransformedEngineering(context), newName);
        }
        return Status.OK_STATUS;
    }

    public void updateRootComponentNames(SystemEngineering se, String newName) {
        Component[] toRename;
        Component[] componentArray = toRename = new Component[]{this.getSystem((BlockArchitecture)SystemEngineeringExt.getSystemAnalysis((SystemEngineering)se)), this.getSystem((BlockArchitecture)SystemEngineeringExt.getLogicalArchitecture((SystemEngineering)se))};
        int n = toRename.length;
        int n2 = 0;
        while (n2 < n) {
            Component rename = componentArray[n2];
            if (rename != null) {
                rename.setName(newName);
                for (TypedElement e : rename.getTypedElements()) {
                    e.setName(newName);
                }
            }
            ++n2;
        }
    }

    private Component getSystem(BlockArchitecture architecture) {
        if (architecture != null) {
            return architecture.getSystem();
        }
        return null;
    }
}

