/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.multiphases.activities;

import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.ui.statushandlers.StatusManager;
import org.polarsys.capella.common.libraries.ModelInformation;
import org.polarsys.capella.core.data.capellamodeller.Library;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.libraries.ui.wizard.newLibrary.LibrarySessionCreationHelper;
import org.polarsys.capella.core.model.helpers.ProjectExt;
import org.polarsys.capella.core.platform.sirius.ui.project.operations.ProjectSessionCreationHelper;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.core.transition.common.handlers.IHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.config.ExtendedTraceabilityConfiguration;
import org.polarsys.capella.core.transition.common.handlers.traceability.config.ITraceabilityConfiguration;
import org.polarsys.capella.core.transition.system.handlers.traceability.LibraryTraceabilityHandler;
import org.polarsys.capella.core.transition.system.helpers.ContextHelper;
import org.polarsys.capella.transition.system2subsystem.activities.InitializeTransformationActivity;
import org.polarsys.capella.transition.system2subsystem.multiphases.activities.MultiphaseTraceabilityHandler;
import org.polarsys.capella.transition.system2subsystem.multiphases.handlers.traceability.config.RecTraceabilityHandler;
import org.polarsys.capella.transition.system2subsystem.multiphases.handlers.traceability.config.SIDTraceabilityHandler;
import org.polarsys.kitalpha.emde.model.ElementExtension;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public final class InitializeMultiphasesTransformationActivity
extends InitializeTransformationActivity {
    protected IHandler createDefaultTraceabilityTransformationHandler() {
        ExtendedTraceabilityConfiguration configuration = new ExtendedTraceabilityConfiguration(){

            protected String getExtensionIdentifier(IContext context) {
                return "transformationTraceabilityConfiguration";
            }

            protected void initHandlers(IContext fContext_p) {
                this.addHandler(fContext_p, (ITraceabilityHandler)new SIDTraceabilityHandler(this.getIdentifier(fContext_p)));
                this.addHandler(fContext_p, new RecTraceabilityHandler());
                this.addHandler(fContext_p, (ITraceabilityHandler)new LibraryTraceabilityHandler());
            }

            public boolean useHandlerForAttachment(EObject source_p, EObject target_p, ITraceabilityHandler handler_p, IContext context_p) {
                if (LibraryTraceabilityHandler.isLibraryElement((EObject)source_p, (IContext)context_p)) {
                    return handler_p instanceof LibraryTraceabilityHandler;
                }
                if (handler_p instanceof RecTraceabilityHandler) {
                    return false;
                }
                return super.useHandlerForAttachment(source_p, target_p, handler_p, context_p);
            }

            public boolean useHandlerForSourceElements(EObject source, ITraceabilityHandler handler, IContext context) {
                if (LibraryTraceabilityHandler.isLibraryElement((EObject)source, (IContext)context)) {
                    return handler instanceof LibraryTraceabilityHandler;
                }
                return super.useHandlerForSourceElements(source, handler, context);
            }

            public boolean useHandlerForTracedElements(EObject source, ITraceabilityHandler handler, IContext context) {
                if (LibraryTraceabilityHandler.isLibraryElement((EObject)source, (IContext)context)) {
                    return handler instanceof LibraryTraceabilityHandler;
                }
                return super.useHandlerForTracedElements(source, handler, context);
            }
        };
        return new MultiphaseTraceabilityHandler((ITraceabilityConfiguration)configuration);
    }

    protected EObject createTargetTransformationContainer(Resource targetResource, IContext context) {
        Project targetTemporaryProject = null;
        Project targetProject = ProjectExt.getProject((Resource)targetResource);
        if (context.get((Object)"DIFFMERGE_DISABLE") == Boolean.TRUE) {
            targetTemporaryProject = targetProject;
        } else {
            try {
                String temporaryProjectName = this.getTemporaryProjectName();
                Session session = null;
                session = targetProject instanceof Library ? new LibrarySessionCreationHelper(true, true).createFullProject(temporaryProjectName, null, Collections.emptyList(), (Collection)ViewpointSelection.getViewpoints((String)"melodymodeller"), (IProgressMonitor)new NullProgressMonitor()) : new ProjectSessionCreationHelper(true, true).createFullProject(temporaryProjectName, null, Collections.emptyList(), (Collection)ViewpointSelection.getViewpoints((String)"melodymodeller"), (IProgressMonitor)new NullProgressMonitor());
                Project project = SessionHelper.getCapellaProject((Session)session);
                session.close((IProgressMonitor)new NullProgressMonitor());
                targetTemporaryProject = (Project)((EditingDomain)context.get((Object)"TRANSITION_TARGET_EDITING_DOMAIN")).getResourceSet().getEObject(EcoreUtil.getURI((EObject)project), true);
                context.put((Object)"FinalizeSubsystemTransitionActivity_Delete_Project", (Object)ResourcesPlugin.getWorkspace().getRoot().getProject(temporaryProjectName));
                Project sourceProject = ContextHelper.getSourceProject((IContext)context);
                for (ElementExtension extension : sourceProject.getOwnedExtensions()) {
                    if (!(extension instanceof ModelInformation)) continue;
                    ElementExtension copy = (ElementExtension)EcoreUtil.copy((EObject)extension);
                    targetTemporaryProject.getOwnedExtensions().add((Object)copy);
                }
            }
            catch (InvocationTargetException exception_p) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.polarsys.capella.transition.system2subsystem", exception_p.getMessage(), (Throwable)exception_p));
            }
            catch (InterruptedException exception_p) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.polarsys.capella.transition.system2subsystem", exception_p.getMessage(), (Throwable)exception_p));
            }
        }
        return targetTemporaryProject;
    }

    private String getTemporaryProjectName() {
        return "MultiphaseTransformation_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
    }
}

