/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingutils.binding;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingutils.binding.ValidationListener;
import com.gradleware.tooling.toolingutils.binding.Validator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class Property<T> {
    public final Object LOCK = new Object();
    private T value;
    private final Validator<T> validator;
    private final Set<ValidationListener> listeners;

    private Property(Validator<T> validator) {
        this.validator = (Validator)Preconditions.checkNotNull(validator);
        this.listeners = new LinkedHashSet<ValidationListener>();
    }

    public T getValue() {
        return this.value;
    }

    public Optional<String> setValue(T value) {
        this.value = value;
        Optional<String> errorMessage = this.validate();
        for (ValidationListener listener : this.getListeners()) {
            listener.validationTriggered(this, errorMessage);
        }
        return errorMessage;
    }

    public Optional<String> validate() {
        return this.validator.validate(this.value);
    }

    public boolean isValid() {
        return !this.validate().isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValidationListener(ValidationListener listener) {
        Object object = this.LOCK;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValidationListener(ValidationListener listener) {
        Object object = this.LOCK;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ValidationListener> getListeners() {
        Object object = this.LOCK;
        synchronized (object) {
            return ImmutableList.copyOf(this.listeners);
        }
    }

    public static <T> Property<T> create(Validator<T> validator) {
        return new Property<T>(validator);
    }
}

