/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.AbstractConnectionRouter;
import org.eclipse.bpmn2.modeler.core.features.ConnectionRoute;
import org.eclipse.bpmn2.modeler.core.features.DefaultConnectionRouter;
import org.eclipse.bpmn2.modeler.core.utils.AnchorSite;
import org.eclipse.bpmn2.modeler.core.utils.AnchorType;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BoundaryEventPositionHelper;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class BendpointConnectionRouter
extends DefaultConnectionRouter {
    protected FreeFormConnection ffc;
    protected Point movedBendpoint;
    protected Point removedBendpoint;
    protected Point[] oldPoints;
    AnchorSite[] sourceAnchorSites;
    AnchorSite[] targetAnchorSites;

    public BendpointConnectionRouter(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canRoute(Connection connection) {
        return super.canRoute(connection) && connection instanceof FreeFormConnection;
    }

    @Override
    public boolean routingNeeded(Connection connection) {
        if (Graphiti.getPeService().getProperty((PropertyContainer)connection, "ROUTING_NET_CONNECTION") != null) {
            return false;
        }
        return super.routingNeeded(connection);
    }

    @Override
    protected void initialize(Connection connection) {
        if (this.oldPoints == null) {
            super.initialize(connection);
            this.ffc = (FreeFormConnection)connection;
            this.movedBendpoint = BendpointConnectionRouter.getMovedBendpoint((Connection)this.ffc);
            if (this.movedBendpoint == null) {
                this.movedBendpoint = BendpointConnectionRouter.getAddedBendpoint((Connection)this.ffc);
            }
            this.removedBendpoint = BendpointConnectionRouter.getRemovedBendpoint((Connection)this.ffc);
            this.findAllShapes();
            if (this.movedBendpoint != null) {
                for (ContainerShape shape : this.allShapes) {
                    if (!GraphicsUtil.contains((Shape)shape, this.movedBendpoint)) continue;
                    this.movedBendpoint = null;
                    break;
                }
            }
            this.oldPoints = new Point[this.ffc.getBendpoints().size() + 2];
            int i = 0;
            this.oldPoints[i++] = GraphicsUtil.createPoint(this.ffc.getStart());
            for (Point p : this.ffc.getBendpoints()) {
                this.oldPoints[i++] = GraphicsUtil.createPoint(p);
            }
            this.oldPoints[i++] = GraphicsUtil.createPoint(this.ffc.getEnd());
            this.calculateAllowedAnchorSites();
        }
    }

    @Override
    public boolean route(Connection connection) {
        this.initialize(connection);
        boolean changed = false;
        if (connection instanceof FreeFormConnection) {
            ConnectionRoute route = this.calculateRoute();
            if (route != null) {
                changed = this.isRouteChanged(route);
                this.applyRoute(route);
            }
            this.dispose();
        }
        return changed;
    }

    protected void calculateAllowedAnchorSites() {
        EObject bo = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)this.source);
        if (bo instanceof BoundaryEvent) {
            this.sourceAnchorSites = this.calculateBoundaryEventAnchorSites(this.source);
        }
        if ((bo = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)this.target)) instanceof BoundaryEvent) {
            this.targetAnchorSites = this.calculateBoundaryEventAnchorSites(this.target);
        }
        if (AnchorType.getType((AnchorContainer)this.source) == AnchorType.CONNECTION) {
            this.sourceAnchorSites = new AnchorSite[1];
            this.sourceAnchorSites[0] = AnchorSite.CENTER;
        }
        if (AnchorType.getType((AnchorContainer)this.target) == AnchorType.CONNECTION) {
            this.targetAnchorSites = new AnchorSite[1];
            this.targetAnchorSites[0] = AnchorSite.CENTER;
        }
        ILocation sPos = Graphiti.getPeService().getLocationRelativeToDiagram(this.source);
        IDimension sSize = GraphicsUtil.calculateSize((PictogramElement)this.source);
        ILocation tPos = Graphiti.getPeService().getLocationRelativeToDiagram(this.target);
        IDimension tSize = GraphicsUtil.calculateSize((PictogramElement)this.target);
        if (this.movedBendpoint != null) {
            boolean expandTargetSites;
            double dt;
            Point sc = GraphicsUtil.getShapeCenter((AnchorContainer)this.source);
            Point tc = GraphicsUtil.getShapeCenter((AnchorContainer)this.target);
            double ds = GraphicsUtil.getLength(this.movedBendpoint, sc);
            boolean expandSourceSites = ds > 2.0 * (dt = GraphicsUtil.getLength(this.movedBendpoint, tc));
            boolean bl = expandTargetSites = dt > 2.0 * ds;
            if (this.sourceAnchorSites == null) {
                if (this.movedBendpoint.getX() < sPos.getX()) {
                    if (this.movedBendpoint.getY() < sPos.getY()) {
                        this.sourceAnchorSites = new AnchorSite[2];
                        this.sourceAnchorSites[0] = AnchorSite.LEFT;
                        this.sourceAnchorSites[1] = AnchorSite.TOP;
                    } else if (sPos.getY() + sSize.getHeight() < this.movedBendpoint.getY()) {
                        this.sourceAnchorSites = new AnchorSite[2];
                        this.sourceAnchorSites[0] = AnchorSite.LEFT;
                        this.sourceAnchorSites[1] = AnchorSite.BOTTOM;
                    } else if (expandSourceSites) {
                        this.sourceAnchorSites = new AnchorSite[3];
                        this.sourceAnchorSites[0] = AnchorSite.LEFT;
                        this.sourceAnchorSites[1] = AnchorSite.TOP;
                        this.sourceAnchorSites[2] = AnchorSite.BOTTOM;
                    } else {
                        this.sourceAnchorSites = new AnchorSite[1];
                        this.sourceAnchorSites[0] = AnchorSite.LEFT;
                    }
                } else if (sPos.getX() + sSize.getWidth() < this.movedBendpoint.getX()) {
                    if (this.movedBendpoint.getY() < sPos.getY()) {
                        this.sourceAnchorSites = new AnchorSite[2];
                        this.sourceAnchorSites[0] = AnchorSite.RIGHT;
                        this.sourceAnchorSites[1] = AnchorSite.TOP;
                    } else if (sPos.getY() + sSize.getHeight() < this.movedBendpoint.getY()) {
                        this.sourceAnchorSites = new AnchorSite[2];
                        this.sourceAnchorSites[0] = AnchorSite.RIGHT;
                        this.sourceAnchorSites[1] = AnchorSite.BOTTOM;
                    } else if (expandSourceSites) {
                        this.sourceAnchorSites = new AnchorSite[3];
                        this.sourceAnchorSites[0] = AnchorSite.RIGHT;
                        this.sourceAnchorSites[1] = AnchorSite.TOP;
                        this.sourceAnchorSites[2] = AnchorSite.BOTTOM;
                    } else {
                        this.sourceAnchorSites = new AnchorSite[1];
                        this.sourceAnchorSites[0] = AnchorSite.RIGHT;
                    }
                } else if (this.movedBendpoint.getY() < sPos.getY()) {
                    if (expandSourceSites) {
                        this.sourceAnchorSites = new AnchorSite[3];
                        this.sourceAnchorSites[0] = AnchorSite.TOP;
                        this.sourceAnchorSites[1] = AnchorSite.LEFT;
                        this.sourceAnchorSites[2] = AnchorSite.RIGHT;
                    } else {
                        this.sourceAnchorSites = new AnchorSite[1];
                        this.sourceAnchorSites[0] = AnchorSite.TOP;
                    }
                } else if (sPos.getY() + sSize.getHeight() < this.movedBendpoint.getY()) {
                    if (expandSourceSites) {
                        this.sourceAnchorSites = new AnchorSite[3];
                        this.sourceAnchorSites[0] = AnchorSite.BOTTOM;
                        this.sourceAnchorSites[1] = AnchorSite.LEFT;
                        this.sourceAnchorSites[2] = AnchorSite.RIGHT;
                    } else {
                        this.sourceAnchorSites = new AnchorSite[1];
                        this.sourceAnchorSites[0] = AnchorSite.BOTTOM;
                    }
                } else {
                    this.sourceAnchorSites = new AnchorSite[0];
                }
            }
            if (this.targetAnchorSites == null) {
                if (this.movedBendpoint.getX() < tPos.getX()) {
                    if (this.movedBendpoint.getY() < tPos.getY()) {
                        this.targetAnchorSites = new AnchorSite[2];
                        this.targetAnchorSites[0] = AnchorSite.LEFT;
                        this.targetAnchorSites[1] = AnchorSite.TOP;
                    } else if (tPos.getY() + tSize.getHeight() < this.movedBendpoint.getY()) {
                        this.targetAnchorSites = new AnchorSite[2];
                        this.targetAnchorSites[0] = AnchorSite.LEFT;
                        this.targetAnchorSites[1] = AnchorSite.BOTTOM;
                    } else if (expandTargetSites) {
                        this.targetAnchorSites = new AnchorSite[3];
                        this.targetAnchorSites[0] = AnchorSite.LEFT;
                        this.targetAnchorSites[1] = AnchorSite.TOP;
                        this.targetAnchorSites[2] = AnchorSite.BOTTOM;
                    } else {
                        this.targetAnchorSites = new AnchorSite[1];
                        this.targetAnchorSites[0] = AnchorSite.LEFT;
                    }
                } else if (tPos.getX() + tSize.getWidth() < this.movedBendpoint.getX()) {
                    if (this.movedBendpoint.getY() < tPos.getY()) {
                        this.targetAnchorSites = new AnchorSite[2];
                        this.targetAnchorSites[0] = AnchorSite.RIGHT;
                        this.targetAnchorSites[1] = AnchorSite.TOP;
                    } else if (tPos.getY() + tSize.getHeight() < this.movedBendpoint.getY()) {
                        this.targetAnchorSites = new AnchorSite[2];
                        this.targetAnchorSites[0] = AnchorSite.RIGHT;
                        this.targetAnchorSites[1] = AnchorSite.BOTTOM;
                    } else if (expandTargetSites) {
                        this.targetAnchorSites = new AnchorSite[3];
                        this.targetAnchorSites[0] = AnchorSite.RIGHT;
                        this.targetAnchorSites[1] = AnchorSite.TOP;
                        this.targetAnchorSites[2] = AnchorSite.BOTTOM;
                    } else {
                        this.targetAnchorSites = new AnchorSite[1];
                        this.targetAnchorSites[0] = AnchorSite.RIGHT;
                    }
                } else if (this.movedBendpoint.getY() < tPos.getY()) {
                    if (expandTargetSites) {
                        this.targetAnchorSites = new AnchorSite[3];
                        this.targetAnchorSites[0] = AnchorSite.TOP;
                        this.targetAnchorSites[1] = AnchorSite.LEFT;
                        this.targetAnchorSites[2] = AnchorSite.RIGHT;
                    } else {
                        this.targetAnchorSites = new AnchorSite[1];
                        this.targetAnchorSites[0] = AnchorSite.TOP;
                    }
                } else if (tPos.getY() + tSize.getHeight() < this.movedBendpoint.getY()) {
                    if (expandTargetSites) {
                        this.targetAnchorSites = new AnchorSite[3];
                        this.targetAnchorSites[0] = AnchorSite.BOTTOM;
                        this.targetAnchorSites[1] = AnchorSite.LEFT;
                        this.targetAnchorSites[2] = AnchorSite.RIGHT;
                    } else {
                        this.targetAnchorSites = new AnchorSite[1];
                        this.targetAnchorSites[0] = AnchorSite.BOTTOM;
                    }
                } else {
                    this.targetAnchorSites = new AnchorSite[0];
                }
            }
            return;
        }
        if (sPos.getX() + sSize.getWidth() < tPos.getX()) {
            if (sPos.getY() + sSize.getHeight() < tPos.getY()) {
                if (this.sourceAnchorSites == null) {
                    this.sourceAnchorSites = new AnchorSite[2];
                    this.sourceAnchorSites[0] = AnchorSite.RIGHT;
                    this.sourceAnchorSites[1] = AnchorSite.BOTTOM;
                }
                if (this.targetAnchorSites == null) {
                    this.targetAnchorSites = new AnchorSite[2];
                    this.targetAnchorSites[0] = AnchorSite.LEFT;
                    this.targetAnchorSites[1] = AnchorSite.TOP;
                }
            } else if (sPos.getY() > tPos.getY() + tSize.getHeight()) {
                if (this.sourceAnchorSites == null) {
                    this.sourceAnchorSites = new AnchorSite[2];
                    this.sourceAnchorSites[0] = AnchorSite.RIGHT;
                    this.sourceAnchorSites[1] = AnchorSite.TOP;
                }
                if (this.targetAnchorSites == null) {
                    this.targetAnchorSites = new AnchorSite[2];
                    this.targetAnchorSites[0] = AnchorSite.LEFT;
                    this.targetAnchorSites[1] = AnchorSite.BOTTOM;
                }
            } else {
                if (this.sourceAnchorSites == null) {
                    this.sourceAnchorSites = new AnchorSite[3];
                    this.sourceAnchorSites[0] = AnchorSite.RIGHT;
                    this.sourceAnchorSites[1] = AnchorSite.TOP;
                    this.sourceAnchorSites[2] = AnchorSite.BOTTOM;
                }
                if (this.targetAnchorSites == null) {
                    this.targetAnchorSites = new AnchorSite[3];
                    this.targetAnchorSites[0] = AnchorSite.LEFT;
                    this.targetAnchorSites[1] = AnchorSite.TOP;
                    this.targetAnchorSites[2] = AnchorSite.BOTTOM;
                }
            }
        } else if (sPos.getX() > tPos.getX() + tSize.getWidth()) {
            if (sPos.getY() + sSize.getHeight() < tPos.getY()) {
                if (this.sourceAnchorSites == null) {
                    this.sourceAnchorSites = new AnchorSite[2];
                    this.sourceAnchorSites[0] = AnchorSite.LEFT;
                    this.sourceAnchorSites[1] = AnchorSite.BOTTOM;
                }
                if (this.targetAnchorSites == null) {
                    this.targetAnchorSites = new AnchorSite[2];
                    this.targetAnchorSites[0] = AnchorSite.RIGHT;
                    this.targetAnchorSites[1] = AnchorSite.TOP;
                }
            } else if (sPos.getY() > tPos.getY() + tSize.getHeight()) {
                if (this.sourceAnchorSites == null) {
                    this.sourceAnchorSites = new AnchorSite[2];
                    this.sourceAnchorSites[0] = AnchorSite.LEFT;
                    this.sourceAnchorSites[1] = AnchorSite.TOP;
                }
                if (this.targetAnchorSites == null) {
                    this.targetAnchorSites = new AnchorSite[2];
                    this.targetAnchorSites[0] = AnchorSite.RIGHT;
                    this.targetAnchorSites[1] = AnchorSite.BOTTOM;
                }
            } else {
                if (this.sourceAnchorSites == null) {
                    this.sourceAnchorSites = new AnchorSite[3];
                    this.sourceAnchorSites[0] = AnchorSite.LEFT;
                    this.sourceAnchorSites[1] = AnchorSite.TOP;
                    this.sourceAnchorSites[2] = AnchorSite.BOTTOM;
                }
                if (this.targetAnchorSites == null) {
                    this.targetAnchorSites = new AnchorSite[3];
                    this.targetAnchorSites[0] = AnchorSite.RIGHT;
                    this.targetAnchorSites[1] = AnchorSite.TOP;
                    this.targetAnchorSites[2] = AnchorSite.BOTTOM;
                }
            }
        } else if (sPos.getY() + sSize.getHeight() < tPos.getY()) {
            if (this.sourceAnchorSites == null) {
                this.sourceAnchorSites = new AnchorSite[3];
                this.sourceAnchorSites[0] = AnchorSite.LEFT;
                this.sourceAnchorSites[1] = AnchorSite.RIGHT;
                this.sourceAnchorSites[2] = AnchorSite.BOTTOM;
            }
            if (this.targetAnchorSites == null) {
                this.targetAnchorSites = new AnchorSite[3];
                this.targetAnchorSites[0] = AnchorSite.LEFT;
                this.targetAnchorSites[1] = AnchorSite.RIGHT;
                this.targetAnchorSites[2] = AnchorSite.TOP;
            }
        } else if (sPos.getY() > tPos.getY() + tSize.getHeight()) {
            if (this.sourceAnchorSites == null) {
                this.sourceAnchorSites = new AnchorSite[3];
                this.sourceAnchorSites[0] = AnchorSite.LEFT;
                this.sourceAnchorSites[1] = AnchorSite.RIGHT;
                this.sourceAnchorSites[2] = AnchorSite.TOP;
            }
            if (this.targetAnchorSites == null) {
                this.targetAnchorSites = new AnchorSite[3];
                this.targetAnchorSites[0] = AnchorSite.LEFT;
                this.targetAnchorSites[1] = AnchorSite.RIGHT;
                this.targetAnchorSites[2] = AnchorSite.BOTTOM;
            }
        } else {
            if (this.sourceAnchorSites == null) {
                this.sourceAnchorSites = new AnchorSite[4];
                this.sourceAnchorSites[0] = AnchorSite.LEFT;
                this.sourceAnchorSites[1] = AnchorSite.RIGHT;
                this.sourceAnchorSites[2] = AnchorSite.TOP;
                this.sourceAnchorSites[3] = AnchorSite.BOTTOM;
            }
            if (this.targetAnchorSites == null) {
                this.targetAnchorSites = new AnchorSite[4];
                this.targetAnchorSites[0] = AnchorSite.LEFT;
                this.targetAnchorSites[1] = AnchorSite.RIGHT;
                this.targetAnchorSites[2] = AnchorSite.TOP;
                this.targetAnchorSites[3] = AnchorSite.BOTTOM;
            }
        }
    }

    protected AnchorSite[] calculateBoundaryEventAnchorSites(Shape shape) {
        AnchorSite[] sites;
        BoundaryEventPositionHelper.PositionOnLine pol = BoundaryEventPositionHelper.getPositionOnLineProperty((PropertyContainer)shape);
        switch (pol.getLocationType()) {
            case BOTTOM: {
                sites = new AnchorSite[]{AnchorSite.BOTTOM};
                break;
            }
            case BOTTOM_LEFT: {
                sites = new AnchorSite[]{AnchorSite.BOTTOM, AnchorSite.LEFT};
                break;
            }
            case BOTTOM_RIGHT: {
                sites = new AnchorSite[]{AnchorSite.BOTTOM, AnchorSite.RIGHT};
                break;
            }
            case LEFT: {
                sites = new AnchorSite[]{AnchorSite.LEFT};
                break;
            }
            case RIGHT: {
                sites = new AnchorSite[]{AnchorSite.RIGHT};
                break;
            }
            case TOP: {
                sites = new AnchorSite[]{AnchorSite.TOP};
                break;
            }
            case TOP_LEFT: {
                sites = new AnchorSite[]{AnchorSite.TOP, AnchorSite.LEFT};
                break;
            }
            case TOP_RIGHT: {
                sites = new AnchorSite[]{AnchorSite.TOP, AnchorSite.RIGHT};
                break;
            }
            default: {
                sites = new AnchorSite[]{AnchorSite.TOP, AnchorSite.LEFT, AnchorSite.BOTTOM, AnchorSite.RIGHT};
            }
        }
        return sites;
    }

    protected boolean shouldCalculate(AnchorSite sourceSite, AnchorSite targetSite) {
        int i = 0;
        while (i < this.sourceAnchorSites.length) {
            if (sourceSite == this.sourceAnchorSites[i]) {
                int j = 0;
                while (j < this.targetAnchorSites.length) {
                    if (targetSite == this.targetAnchorSites[j]) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    protected ConnectionRoute calculateRoute() {
        if (this.isSelfConnection()) {
            return this.calculateSelfConnectionRoute();
        }
        ConnectionRoute route = new ConnectionRoute(this, 1, this.source, this.target);
        Point start = GraphicsUtil.createPoint((Anchor)this.sourceAnchor);
        Point end = GraphicsUtil.createPoint((Anchor)this.targetAnchor);
        route.add(start);
        int i = 1;
        while (i < this.oldPoints.length - 1) {
            route.add(this.oldPoints[i]);
            ++i;
        }
        route.add(end);
        return route;
    }

    protected ConnectionRoute calculateSelfConnectionRoute() {
        if (!this.isSelfConnection()) {
            return null;
        }
        if (this.movedBendpoint == null && this.ffc.getStart() != this.ffc.getEnd() && this.ffc.getBendpoints().size() > 0 && !BendpointConnectionRouter.forceRouting((Connection)this.ffc)) {
            return null;
        }
        ILocation loc = peService.getLocationRelativeToDiagram(this.target);
        IDimension size = GraphicsUtil.calculateSize((PictogramElement)this.target);
        Point p = Graphiti.getCreateService().createPoint(loc.getX() + size.getWidth() / 2, loc.getY());
        FixPointAnchor topAnchor = (FixPointAnchor)this.ffc.getEnd();
        AnchorUtil.moveAnchor(topAnchor, p);
        p = Graphiti.getCreateService().createPoint(loc.getX() + size.getWidth(), loc.getY() + size.getHeight() / 2);
        FixPointAnchor rightAnchor = (FixPointAnchor)this.ffc.getStart();
        AnchorUtil.moveAnchor(rightAnchor, p);
        Point right = GraphicsUtil.createPoint((Anchor)rightAnchor);
        right.setX(right.getX() + 20);
        Point top = GraphicsUtil.createPoint((Anchor)topAnchor);
        top.setY(top.getY() - 20);
        Point corner = Graphiti.getCreateService().createPoint(right.getX(), top.getY());
        p = this.movedBendpoint;
        if (p != null) {
            int x = p.getX();
            int y = p.getY();
            if (x > loc.getX() + size.getWidth() + 2) {
                right.setX(x);
                corner.setX(x);
            }
            if (y < loc.getY() - 2) {
                top.setY(y);
                corner.setY(y);
            }
        }
        ConnectionRoute route = new ConnectionRoute(this, 1, this.source, this.target);
        route.add(GraphicsUtil.createPoint((Anchor)rightAnchor));
        route.add(right);
        route.add(corner);
        route.add(top);
        route.add(GraphicsUtil.createPoint((Anchor)topAnchor));
        return route;
    }

    protected boolean isRouteChanged(ConnectionRoute route) {
        if (route == null || route.size() == 0) {
            return false;
        }
        if (this.oldPoints.length != route.size()) {
            return true;
        }
        int i = 0;
        while (i < this.oldPoints.length) {
            Point p1 = this.oldPoints[i];
            Point p2 = route.get(i);
            if (!GraphicsUtil.pointsEqual(p1, p2)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void applyRoute(ConnectionRoute route) {
        route.apply(this.ffc, this.sourceAnchor, this.targetAnchor);
        DIUtils.updateDIEdge((Connection)this.ffc);
    }

    protected AnchorSite getNextAnchorSite(AnchorSite site) {
        switch (site) {
            case BOTTOM: {
                return AnchorSite.LEFT;
            }
            case LEFT: {
                return AnchorSite.RIGHT;
            }
            case RIGHT: {
                return AnchorSite.TOP;
            }
            case TOP: {
                return AnchorSite.BOTTOM;
            }
            case CENTER: {
                return AnchorSite.CENTER;
            }
        }
        return site;
    }

    public static void setMovedBendpoint(Connection connection, int index) {
        BendpointConnectionRouter.setInterestingBendpoint(connection, "moved.", index);
    }

    public static void setAddedBendpoint(Connection connection, int index) {
        BendpointConnectionRouter.setInterestingBendpoint(connection, "added.", index);
    }

    public static void setRemovedBendpoint(Connection connection, Point p) {
        AbstractConnectionRouter.setRoutingInfo(connection, "removed.bendpoint", String.valueOf(p.getX()) + "." + p.getY());
    }

    public static void setFixedBendpoint(Connection connection, int index) {
        BendpointConnectionRouter.setInterestingBendpoint(connection, "fixed." + index + ".", index);
    }

    public static void setOldBendpointLocation(Connection connection, Point p) {
        AbstractConnectionRouter.setRoutingInfo(connection, "oldloc.bendpoint", String.valueOf(p.getX()) + "." + p.getY());
    }

    protected static void setInterestingBendpoint(Connection connection, String type, int index) {
        if (connection instanceof FreeFormConnection) {
            int size = ((FreeFormConnection)connection).getBendpoints().size();
            if (index >= 0 && size > 0) {
                if (index >= size) {
                    index = size - 1;
                }
                AbstractConnectionRouter.setRoutingInfoInt(connection, String.valueOf(type) + "bendpoint", index);
            } else {
                AbstractConnectionRouter.removeRoutingInfo(connection, String.valueOf(type) + "bendpoint");
            }
        }
    }

    public static Point getMovedBendpoint(Connection connection) {
        return BendpointConnectionRouter.getInterestingBendpoint(connection, "moved.");
    }

    public static Point getAddedBendpoint(Connection connection) {
        return BendpointConnectionRouter.getInterestingBendpoint(connection, "added.");
    }

    public static Point getRemovedBendpoint(Connection connection) {
        String value = AbstractConnectionRouter.getRoutingInfo(connection, "removed.bendpoint");
        if (value != null && !value.isEmpty()) {
            String[] b = value.split("\\.");
            int x = Integer.parseInt(b[0]);
            int y = Integer.parseInt(b[1]);
            return GraphicsUtil.createPoint(x, y);
        }
        return null;
    }

    public static Point getFixedBendpoint(Connection connection, int index) {
        return BendpointConnectionRouter.getInterestingBendpoint(connection, "fixed." + index + ".");
    }

    public static Point getOldBendpointLocation(Connection connection) {
        String value = AbstractConnectionRouter.getRoutingInfo(connection, "oldloc.bendpoint");
        if (value != null && !value.isEmpty()) {
            String[] b = value.split("\\.");
            int x = Integer.parseInt(b[0]);
            int y = Integer.parseInt(b[1]);
            return GraphicsUtil.createPoint(x, y);
        }
        return null;
    }

    protected static Point getInterestingBendpoint(Connection connection, String type) {
        try {
            int index = AbstractConnectionRouter.getRoutingInfoInt(connection, String.valueOf(type) + "bendpoint");
            return (Point)((FreeFormConnection)connection).getBendpoints().get(index);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

