/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.di;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.utils.SimpleTreeIterator;

public class DiagramElementTreeNode
extends SimpleTreeIterator<DiagramElementTreeNode> {
    private static List<DiagramElementTreeNode> EMPTY = new ArrayList<DiagramElementTreeNode>();
    private DiagramElementTreeNode parent;
    private BaseElement baseElement;
    private List<DiagramElementTreeNode> children;
    private boolean checked = true;
    private BPMNShape bpmnShape;

    public DiagramElementTreeNode(DiagramElementTreeNode parent, BaseElement element) {
        this.parent = parent;
        this.baseElement = element;
    }

    public BaseElement getBaseElement() {
        return this.baseElement;
    }

    public void setBaseElement(BaseElement baseElement) {
        this.baseElement = baseElement;
    }

    public BPMNShape getBpmnShape() {
        return this.bpmnShape;
    }

    public void setBpmnShape(BPMNShape bpmnShape) {
        this.bpmnShape = bpmnShape;
    }

    public DiagramElementTreeNode getParent() {
        return this.parent;
    }

    public boolean getChecked() {
        return this.checked;
    }

    private void setParentChecked(boolean checked) {
        if (this.parent != null) {
            if (!checked) {
                if (this.parent.hasChildren()) {
                    for (DiagramElementTreeNode child : this.parent.children) {
                        if (!child.getChecked()) continue;
                        checked = true;
                        break;
                    }
                }
                this.parent.checked = checked;
            } else {
                this.parent.checked = true;
            }
            this.parent.setParentChecked(checked);
        }
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        if (this.hasChildren()) {
            for (DiagramElementTreeNode child : this.children) {
                child.setChecked(checked);
            }
        }
        this.setParentChecked(checked);
    }

    public DiagramElementTreeNode addChild(BaseElement element) {
        DiagramElementTreeNode child = this.getChild(element);
        if (child != null) {
            return child;
        }
        if (this.children == null) {
            this.children = new ArrayList<DiagramElementTreeNode>();
        }
        DiagramElementTreeNode newElement = new DiagramElementTreeNode(this, element);
        this.children.add(newElement);
        return newElement;
    }

    public DiagramElementTreeNode getChild(BaseElement element) {
        if (this.hasChildren()) {
            for (DiagramElementTreeNode child : this.children) {
                if (child.getBaseElement() != element) continue;
                return child;
            }
        }
        return null;
    }

    public void removeChild(BaseElement element) {
        if (this.hasChildren()) {
            for (DiagramElementTreeNode child : this.children) {
                if (child.getBaseElement() != element) continue;
                this.children.remove(child);
                break;
            }
        }
    }

    public void removeChild(DiagramElementTreeNode node) {
        if (this.hasChildren()) {
            for (DiagramElementTreeNode child : this.children) {
                if (child == node) {
                    this.children.remove(child);
                    return;
                }
                child.removeChild(node);
            }
        }
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public List<DiagramElementTreeNode> getChildren() {
        if (this.hasChildren()) {
            return this.children;
        }
        return EMPTY;
    }

    @Override
    public Iterator<DiagramElementTreeNode> iterator() {
        return new SimpleTreeIterator.TreeIterator(this.getChildren());
    }
}

